/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest;

public class DescribeTagsRequestMarshaller
implements Marshaller<Request<DescribeTagsRequest>, DescribeTagsRequest> {
    public Request<DescribeTagsRequest> marshall(DescribeTagsRequest describeTagsRequest) {
        if (describeTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeTagsRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "DescribeTags");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTagsRequest.resourceArns().isEmpty() && !(describeTagsRequest.resourceArns() instanceof SdkAutoConstructList)) {
            request.addParameter("ResourceArns", "");
        } else if (!describeTagsRequest.resourceArns().isEmpty() && !(describeTagsRequest.resourceArns() instanceof SdkAutoConstructList)) {
            List<String> resourceArnsList = describeTagsRequest.resourceArns();
            int resourceArnsListIndex = 1;
            for (String resourceArnsListValue : resourceArnsList) {
                if (resourceArnsListValue != null) {
                    request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringConversion.fromString((String)resourceArnsListValue));
                }
                ++resourceArnsListIndex;
            }
        }
        return request;
    }
}

