/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest;

public class DescribeAccountLimitsRequestMarshaller
implements Marshaller<Request<DescribeAccountLimitsRequest>, DescribeAccountLimitsRequest> {
    public Request<DescribeAccountLimitsRequest> marshall(DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        if (describeAccountLimitsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeAccountLimitsRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "DescribeAccountLimits");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAccountLimitsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeAccountLimitsRequest.marker()));
        }
        if (describeAccountLimitsRequest.pageSize() != null) {
            request.addParameter("PageSize", StringConversion.fromInteger((Integer)describeAccountLimitsRequest.pageSize()));
        }
        return request;
    }
}

