/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher;

public class CreateTargetGroupRequestMarshaller
implements Marshaller<Request<CreateTargetGroupRequest>, CreateTargetGroupRequest> {
    public Request<CreateTargetGroupRequest> marshall(CreateTargetGroupRequest createTargetGroupRequest) {
        Matcher matcher;
        if (createTargetGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createTargetGroupRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "CreateTargetGroup");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTargetGroupRequest.name() != null) {
            request.addParameter("Name", StringConversion.fromString((String)createTargetGroupRequest.name()));
        }
        if (createTargetGroupRequest.protocolAsString() != null) {
            request.addParameter("Protocol", StringConversion.fromString((String)createTargetGroupRequest.protocolAsString()));
        }
        if (createTargetGroupRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)createTargetGroupRequest.port()));
        }
        if (createTargetGroupRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)createTargetGroupRequest.vpcId()));
        }
        if (createTargetGroupRequest.healthCheckProtocolAsString() != null) {
            request.addParameter("HealthCheckProtocol", StringConversion.fromString((String)createTargetGroupRequest.healthCheckProtocolAsString()));
        }
        if (createTargetGroupRequest.healthCheckPort() != null) {
            request.addParameter("HealthCheckPort", StringConversion.fromString((String)createTargetGroupRequest.healthCheckPort()));
        }
        if (createTargetGroupRequest.healthCheckPath() != null) {
            request.addParameter("HealthCheckPath", StringConversion.fromString((String)createTargetGroupRequest.healthCheckPath()));
        }
        if (createTargetGroupRequest.healthCheckIntervalSeconds() != null) {
            request.addParameter("HealthCheckIntervalSeconds", StringConversion.fromInteger((Integer)createTargetGroupRequest.healthCheckIntervalSeconds()));
        }
        if (createTargetGroupRequest.healthCheckTimeoutSeconds() != null) {
            request.addParameter("HealthCheckTimeoutSeconds", StringConversion.fromInteger((Integer)createTargetGroupRequest.healthCheckTimeoutSeconds()));
        }
        if (createTargetGroupRequest.healthyThresholdCount() != null) {
            request.addParameter("HealthyThresholdCount", StringConversion.fromInteger((Integer)createTargetGroupRequest.healthyThresholdCount()));
        }
        if (createTargetGroupRequest.unhealthyThresholdCount() != null) {
            request.addParameter("UnhealthyThresholdCount", StringConversion.fromInteger((Integer)createTargetGroupRequest.unhealthyThresholdCount()));
        }
        if ((matcher = createTargetGroupRequest.matcher()) != null && matcher.httpCode() != null) {
            request.addParameter("Matcher.HttpCode", StringConversion.fromString((String)matcher.httpCode()));
        }
        if (createTargetGroupRequest.targetTypeAsString() != null) {
            request.addParameter("TargetType", StringConversion.fromString((String)createTargetGroupRequest.targetTypeAsString()));
        }
        return request;
    }
}

