/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest;

public class RemoveTagsRequestMarshaller
implements Marshaller<Request<RemoveTagsRequest>, RemoveTagsRequest> {
    public Request<RemoveTagsRequest> marshall(RemoveTagsRequest removeTagsRequest) {
        if (removeTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)removeTagsRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "RemoveTags");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (removeTagsRequest.resourceArns().isEmpty() && !(removeTagsRequest.resourceArns() instanceof SdkAutoConstructList)) {
            request.addParameter("ResourceArns", "");
        } else if (!removeTagsRequest.resourceArns().isEmpty() && !(removeTagsRequest.resourceArns() instanceof SdkAutoConstructList)) {
            List<String> resourceArnsList = removeTagsRequest.resourceArns();
            int resourceArnsListIndex = 1;
            for (String resourceArnsListValue : resourceArnsList) {
                if (resourceArnsListValue != null) {
                    request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringConversion.fromString((String)resourceArnsListValue));
                }
                ++resourceArnsListIndex;
            }
        }
        if (removeTagsRequest.tagKeys().isEmpty() && !(removeTagsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!removeTagsRequest.tagKeys().isEmpty() && !(removeTagsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = removeTagsRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.member." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        return request;
    }
}

