/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;

public class ModifyRuleRequestMarshaller
implements Marshaller<Request<ModifyRuleRequest>, ModifyRuleRequest> {
    public Request<ModifyRuleRequest> marshall(ModifyRuleRequest modifyRuleRequest) {
        if (modifyRuleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyRuleRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "ModifyRule");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyRuleRequest.ruleArn() != null) {
            request.addParameter("RuleArn", StringConversion.fromString((String)modifyRuleRequest.ruleArn()));
        }
        if (modifyRuleRequest.conditions().isEmpty() && !(modifyRuleRequest.conditions() instanceof SdkAutoConstructList)) {
            request.addParameter("Conditions", "");
        } else if (!modifyRuleRequest.conditions().isEmpty() && !(modifyRuleRequest.conditions() instanceof SdkAutoConstructList)) {
            List<RuleCondition> conditionsList = modifyRuleRequest.conditions();
            int conditionsListIndex = 1;
            for (RuleCondition conditionsListValue : conditionsList) {
                if (conditionsListValue.field() != null) {
                    request.addParameter("Conditions.member." + conditionsListIndex + ".Field", StringConversion.fromString((String)conditionsListValue.field()));
                }
                if (conditionsListValue.values().isEmpty() && !(conditionsListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Conditions.member." + conditionsListIndex + ".Values", "");
                } else if (!conditionsListValue.values().isEmpty() && !(conditionsListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = conditionsListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Conditions.member." + conditionsListIndex + ".Values.member." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++conditionsListIndex;
            }
        }
        if (modifyRuleRequest.actions().isEmpty() && !(modifyRuleRequest.actions() instanceof SdkAutoConstructList)) {
            request.addParameter("Actions", "");
        } else if (!modifyRuleRequest.actions().isEmpty() && !(modifyRuleRequest.actions() instanceof SdkAutoConstructList)) {
            List<Action> actionsList = modifyRuleRequest.actions();
            int actionsListIndex = 1;
            for (Action actionsListValue : actionsList) {
                if (actionsListValue.typeAsString() != null) {
                    request.addParameter("Actions.member." + actionsListIndex + ".Type", StringConversion.fromString((String)actionsListValue.typeAsString()));
                }
                if (actionsListValue.targetGroupArn() != null) {
                    request.addParameter("Actions.member." + actionsListIndex + ".TargetGroupArn", StringConversion.fromString((String)actionsListValue.targetGroupArn()));
                }
                ++actionsListIndex;
            }
        }
        return request;
    }
}

