/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;

public class DescribeTargetHealthRequestMarshaller
implements Marshaller<Request<DescribeTargetHealthRequest>, DescribeTargetHealthRequest> {
    public Request<DescribeTargetHealthRequest> marshall(DescribeTargetHealthRequest describeTargetHealthRequest) {
        if (describeTargetHealthRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeTargetHealthRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "DescribeTargetHealth");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTargetHealthRequest.targetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringConversion.fromString((String)describeTargetHealthRequest.targetGroupArn()));
        }
        if (describeTargetHealthRequest.targets().isEmpty() && !(describeTargetHealthRequest.targets() instanceof SdkAutoConstructList)) {
            request.addParameter("Targets", "");
        } else if (!describeTargetHealthRequest.targets().isEmpty() && !(describeTargetHealthRequest.targets() instanceof SdkAutoConstructList)) {
            List<TargetDescription> targetsList = describeTargetHealthRequest.targets();
            int targetsListIndex = 1;
            for (TargetDescription targetsListValue : targetsList) {
                if (targetsListValue.id() != null) {
                    request.addParameter("Targets.member." + targetsListIndex + ".Id", StringConversion.fromString((String)targetsListValue.id()));
                }
                if (targetsListValue.port() != null) {
                    request.addParameter("Targets.member." + targetsListIndex + ".Port", StringConversion.fromInteger((Integer)targetsListValue.port()));
                }
                if (targetsListValue.availabilityZone() != null) {
                    request.addParameter("Targets.member." + targetsListIndex + ".AvailabilityZone", StringConversion.fromString((String)targetsListValue.availabilityZone()));
                }
                ++targetsListIndex;
            }
        }
        return request;
    }
}

