/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest;

public class DeleteListenerRequestMarshaller
implements Marshaller<Request<DeleteListenerRequest>, DeleteListenerRequest> {
    public Request<DeleteListenerRequest> marshall(DeleteListenerRequest deleteListenerRequest) {
        if (deleteListenerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteListenerRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "DeleteListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteListenerRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringConversion.fromString((String)deleteListenerRequest.listenerArn()));
        }
        return request;
    }
}

