/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackendServerDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackendServerDescription> {
    private static final SdkField<Integer> INSTANCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BackendServerDescription.getter(BackendServerDescription::instancePort)).setter(BackendServerDescription.setter(Builder::instancePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePort").build()}).build();
    private static final SdkField<List<String>> POLICY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BackendServerDescription.getter(BackendServerDescription::policyNames)).setter(BackendServerDescription.setter(Builder::policyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PORT_FIELD, POLICY_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer instancePort;
    private final List<String> policyNames;

    private BackendServerDescription(BuilderImpl builder) {
        this.instancePort = builder.instancePort;
        this.policyNames = builder.policyNames;
    }

    public Integer instancePort() {
        return this.instancePort;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendServerDescription)) {
            return false;
        }
        BackendServerDescription other = (BackendServerDescription)obj;
        return Objects.equals(this.instancePort(), other.instancePort()) && Objects.equals(this.policyNames(), other.policyNames());
    }

    public String toString() {
        return ToString.builder((String)"BackendServerDescription").add("InstancePort", (Object)this.instancePort()).add("PolicyNames", this.policyNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstancePort": {
                return Optional.ofNullable(clazz.cast(this.instancePort()));
            }
            case "PolicyNames": {
                return Optional.ofNullable(clazz.cast(this.policyNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendServerDescription, T> g) {
        return obj -> g.apply((BackendServerDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instancePort;
        private List<String> policyNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackendServerDescription model) {
            this.instancePort(model.instancePort);
            this.policyNames(model.policyNames);
        }

        public final Integer getInstancePort() {
            return this.instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        public BackendServerDescription build() {
            return new BackendServerDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackendServerDescription> {
        public Builder instancePort(Integer var1);

        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);
    }
}

