/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingAsyncClient;
import software.amazon.awssdk.services.elasticloadbalancing.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.waiters.ElasticLoadBalancingAsyncWaiter;
import software.amazon.awssdk.services.elasticloadbalancing.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultElasticLoadBalancingAsyncWaiter
implements ElasticLoadBalancingAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final ElasticLoadBalancingAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeInstanceHealthResponse> instanceDeregisteredWaiter;
    private final AsyncWaiter<DescribeInstanceHealthResponse> anyInstanceInServiceWaiter;
    private final AsyncWaiter<DescribeInstanceHealthResponse> instanceInServiceWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultElasticLoadBalancingAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (ElasticLoadBalancingAsyncClient)ElasticLoadBalancingAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.instanceDeregisteredWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInstanceHealthResponse.class).acceptors(DefaultElasticLoadBalancingAsyncWaiter.instanceDeregisteredWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingAsyncWaiter.instanceDeregisteredWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.anyInstanceInServiceWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInstanceHealthResponse.class).acceptors(DefaultElasticLoadBalancingAsyncWaiter.anyInstanceInServiceWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingAsyncWaiter.anyInstanceInServiceWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.instanceInServiceWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInstanceHealthResponse.class).acceptors(DefaultElasticLoadBalancingAsyncWaiter.instanceInServiceWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingAsyncWaiter.instanceInServiceWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilAnyInstanceInService(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        return this.anyInstanceInServiceWaiter.runAsync(() -> this.client.describeInstanceHealth(this.applyWaitersUserAgent(describeInstanceHealthRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilAnyInstanceInService(DescribeInstanceHealthRequest describeInstanceHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.anyInstanceInServiceWaiter.runAsync(() -> this.client.describeInstanceHealth(this.applyWaitersUserAgent(describeInstanceHealthRequest)), DefaultElasticLoadBalancingAsyncWaiter.anyInstanceInServiceWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceDeregistered(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        return this.instanceDeregisteredWaiter.runAsync(() -> this.client.describeInstanceHealth(this.applyWaitersUserAgent(describeInstanceHealthRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceDeregistered(DescribeInstanceHealthRequest describeInstanceHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceDeregisteredWaiter.runAsync(() -> this.client.describeInstanceHealth(this.applyWaitersUserAgent(describeInstanceHealthRequest)), DefaultElasticLoadBalancingAsyncWaiter.instanceDeregisteredWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceInService(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        return this.instanceInServiceWaiter.runAsync(() -> this.client.describeInstanceHealth(this.applyWaitersUserAgent(describeInstanceHealthRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceInService(DescribeInstanceHealthRequest describeInstanceHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceInServiceWaiter.runAsync(() -> this.client.describeInstanceHealth(this.applyWaitersUserAgent(describeInstanceHealthRequest)), DefaultElasticLoadBalancingAsyncWaiter.instanceInServiceWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeInstanceHealthResponse>> instanceDeregisteredWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstanceHealthResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstanceHealthResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("InstanceStates").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "OutOfService"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingAsyncWaiter.errorCode(error), "InvalidInstance")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstanceHealthResponse>> anyInstanceInServiceWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstanceHealthResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstanceHealthResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("InstanceStates").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "InService"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstanceHealthResponse>> instanceInServiceWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstanceHealthResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstanceHealthResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("InstanceStates").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "InService"));
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingAsyncWaiter.errorCode(error), "InvalidInstance")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration instanceDeregisteredWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration anyInstanceInServiceWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceInServiceWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static ElasticLoadBalancingAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends ElasticLoadBalancingRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticLoadBalancingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements ElasticLoadBalancingAsyncWaiter.Builder {
        private ElasticLoadBalancingAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public ElasticLoadBalancingAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public ElasticLoadBalancingAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public ElasticLoadBalancingAsyncWaiter.Builder client(ElasticLoadBalancingAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public ElasticLoadBalancingAsyncWaiter build() {
            return new DefaultElasticLoadBalancingAsyncWaiter(this);
        }
    }
}

