/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PortsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLoadBalancerListenersRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, DeleteLoadBalancerListenersRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerName").getter(DeleteLoadBalancerListenersRequest.getter(DeleteLoadBalancerListenersRequest::loadBalancerName)).setter(DeleteLoadBalancerListenersRequest.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<List<Integer>> LOAD_BALANCER_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancerPorts").getter(DeleteLoadBalancerListenersRequest.getter(DeleteLoadBalancerListenersRequest::loadBalancerPorts)).setter(DeleteLoadBalancerListenersRequest.setter(Builder::loadBalancerPorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerPorts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, LOAD_BALANCER_PORTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteLoadBalancerListenersRequest.memberNameToFieldInitializer();
    private final String loadBalancerName;
    private final List<Integer> loadBalancerPorts;

    private DeleteLoadBalancerListenersRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerPorts = builder.loadBalancerPorts;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final boolean hasLoadBalancerPorts() {
        return this.loadBalancerPorts != null && !(this.loadBalancerPorts instanceof SdkAutoConstructList);
    }

    public final List<Integer> loadBalancerPorts() {
        return this.loadBalancerPorts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancerPorts() ? this.loadBalancerPorts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLoadBalancerListenersRequest)) {
            return false;
        }
        DeleteLoadBalancerListenersRequest other = (DeleteLoadBalancerListenersRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && this.hasLoadBalancerPorts() == other.hasLoadBalancerPorts() && Objects.equals(this.loadBalancerPorts(), other.loadBalancerPorts());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteLoadBalancerListenersRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("LoadBalancerPorts", this.hasLoadBalancerPorts() ? this.loadBalancerPorts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "LoadBalancerPorts": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerPorts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LoadBalancerName", LOAD_BALANCER_NAME_FIELD);
        map.put("LoadBalancerPorts", LOAD_BALANCER_PORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteLoadBalancerListenersRequest, T> g) {
        return obj -> g.apply((DeleteLoadBalancerListenersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<Integer> loadBalancerPorts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLoadBalancerListenersRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.loadBalancerPorts(model.loadBalancerPorts);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final Collection<Integer> getLoadBalancerPorts() {
            if (this.loadBalancerPorts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loadBalancerPorts;
        }

        public final void setLoadBalancerPorts(Collection<Integer> loadBalancerPorts) {
            this.loadBalancerPorts = PortsCopier.copy(loadBalancerPorts);
        }

        @Override
        public final Builder loadBalancerPorts(Collection<Integer> loadBalancerPorts) {
            this.loadBalancerPorts = PortsCopier.copy(loadBalancerPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerPorts(Integer ... loadBalancerPorts) {
            this.loadBalancerPorts(Arrays.asList(loadBalancerPorts));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLoadBalancerListenersRequest build() {
            return new DeleteLoadBalancerListenersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteLoadBalancerListenersRequest> {
        public Builder loadBalancerName(String var1);

        public Builder loadBalancerPorts(Collection<Integer> var1);

        public Builder loadBalancerPorts(Integer ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

