/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAppCookieStickinessPolicyRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, CreateAppCookieStickinessPolicyRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerName").getter(CreateAppCookieStickinessPolicyRequest.getter(CreateAppCookieStickinessPolicyRequest::loadBalancerName)).setter(CreateAppCookieStickinessPolicyRequest.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(CreateAppCookieStickinessPolicyRequest.getter(CreateAppCookieStickinessPolicyRequest::policyName)).setter(CreateAppCookieStickinessPolicyRequest.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> COOKIE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CookieName").getter(CreateAppCookieStickinessPolicyRequest.getter(CreateAppCookieStickinessPolicyRequest::cookieName)).setter(CreateAppCookieStickinessPolicyRequest.setter(Builder::cookieName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookieName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, POLICY_NAME_FIELD, COOKIE_NAME_FIELD));
    private final String loadBalancerName;
    private final String policyName;
    private final String cookieName;

    private CreateAppCookieStickinessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.policyName = builder.policyName;
        this.cookieName = builder.cookieName;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String cookieName() {
        return this.cookieName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookieName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppCookieStickinessPolicyRequest)) {
            return false;
        }
        CreateAppCookieStickinessPolicyRequest other = (CreateAppCookieStickinessPolicyRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.cookieName(), other.cookieName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAppCookieStickinessPolicyRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("PolicyName", (Object)this.policyName()).add("CookieName", (Object)this.cookieName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "CookieName": {
                return Optional.ofNullable(clazz.cast(this.cookieName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppCookieStickinessPolicyRequest, T> g) {
        return obj -> g.apply((CreateAppCookieStickinessPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String policyName;
        private String cookieName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppCookieStickinessPolicyRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.policyName(model.policyName);
            this.cookieName(model.cookieName);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getCookieName() {
            return this.cookieName;
        }

        public final void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        @Override
        public final Builder cookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppCookieStickinessPolicyRequest build() {
            return new CreateAppCookieStickinessPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAppCookieStickinessPolicyRequest> {
        public Builder loadBalancerName(String var1);

        public Builder policyName(String var1);

        public Builder cookieName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

