/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The policies for a load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Policies implements SdkPojo, Serializable, ToCopyableBuilder<Policies.Builder, Policies> {
    private static final SdkField<List<AppCookieStickinessPolicy>> APP_COOKIE_STICKINESS_POLICIES_FIELD = SdkField
            .<List<AppCookieStickinessPolicy>> builder(MarshallingType.LIST)
            .getter(getter(Policies::appCookieStickinessPolicies))
            .setter(setter(Builder::appCookieStickinessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppCookieStickinessPolicies")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppCookieStickinessPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppCookieStickinessPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LBCookieStickinessPolicy>> LB_COOKIE_STICKINESS_POLICIES_FIELD = SdkField
            .<List<LBCookieStickinessPolicy>> builder(MarshallingType.LIST)
            .getter(getter(Policies::lbCookieStickinessPolicies))
            .setter(setter(Builder::lbCookieStickinessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LBCookieStickinessPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LBCookieStickinessPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(LBCookieStickinessPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OTHER_POLICIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Policies::otherPolicies))
            .setter(setter(Builder::otherPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APP_COOKIE_STICKINESS_POLICIES_FIELD, LB_COOKIE_STICKINESS_POLICIES_FIELD, OTHER_POLICIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AppCookieStickinessPolicy> appCookieStickinessPolicies;

    private final List<LBCookieStickinessPolicy> lbCookieStickinessPolicies;

    private final List<String> otherPolicies;

    private Policies(BuilderImpl builder) {
        this.appCookieStickinessPolicies = builder.appCookieStickinessPolicies;
        this.lbCookieStickinessPolicies = builder.lbCookieStickinessPolicies;
        this.otherPolicies = builder.otherPolicies;
    }

    /**
     * Returns true if the AppCookieStickinessPolicies property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasAppCookieStickinessPolicies() {
        return appCookieStickinessPolicies != null && !(appCookieStickinessPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAppCookieStickinessPolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
     */
    public List<AppCookieStickinessPolicy> appCookieStickinessPolicies() {
        return appCookieStickinessPolicies;
    }

    /**
     * Returns true if the LBCookieStickinessPolicies property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasLbCookieStickinessPolicies() {
        return lbCookieStickinessPolicies != null && !(lbCookieStickinessPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLbCookieStickinessPolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
     */
    public List<LBCookieStickinessPolicy> lbCookieStickinessPolicies() {
        return lbCookieStickinessPolicies;
    }

    /**
     * Returns true if the OtherPolicies property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOtherPolicies() {
        return otherPolicies != null && !(otherPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The policies other than the stickiness policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOtherPolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The policies other than the stickiness policies.
     */
    public List<String> otherPolicies() {
        return otherPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appCookieStickinessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(lbCookieStickinessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(otherPolicies());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policies)) {
            return false;
        }
        Policies other = (Policies) obj;
        return Objects.equals(appCookieStickinessPolicies(), other.appCookieStickinessPolicies())
                && Objects.equals(lbCookieStickinessPolicies(), other.lbCookieStickinessPolicies())
                && Objects.equals(otherPolicies(), other.otherPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Policies").add("AppCookieStickinessPolicies", appCookieStickinessPolicies())
                .add("LBCookieStickinessPolicies", lbCookieStickinessPolicies()).add("OtherPolicies", otherPolicies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppCookieStickinessPolicies":
            return Optional.ofNullable(clazz.cast(appCookieStickinessPolicies()));
        case "LBCookieStickinessPolicies":
            return Optional.ofNullable(clazz.cast(lbCookieStickinessPolicies()));
        case "OtherPolicies":
            return Optional.ofNullable(clazz.cast(otherPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Policies, T> g) {
        return obj -> g.apply((Policies) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Policies> {
        /**
         * <p>
         * The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
         * </p>
         * 
         * @param appCookieStickinessPolicies
         *        The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appCookieStickinessPolicies(Collection<AppCookieStickinessPolicy> appCookieStickinessPolicies);

        /**
         * <p>
         * The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
         * </p>
         * 
         * @param appCookieStickinessPolicies
         *        The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appCookieStickinessPolicies(AppCookieStickinessPolicy... appCookieStickinessPolicies);

        /**
         * <p>
         * The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AppCookieStickinessPolicy>.Builder}
         * avoiding the need to create one manually via {@link List<AppCookieStickinessPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AppCookieStickinessPolicy>.Builder#build()} is called
         * immediately and its result is passed to {@link #appCookieStickinessPolicies(List<AppCookieStickinessPolicy>)}
         * .
         * 
         * @param appCookieStickinessPolicies
         *        a consumer that will call methods on {@link List<AppCookieStickinessPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appCookieStickinessPolicies(List<AppCookieStickinessPolicy>)
         */
        Builder appCookieStickinessPolicies(Consumer<AppCookieStickinessPolicy.Builder>... appCookieStickinessPolicies);

        /**
         * <p>
         * The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
         * </p>
         * 
         * @param lbCookieStickinessPolicies
         *        The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lbCookieStickinessPolicies(Collection<LBCookieStickinessPolicy> lbCookieStickinessPolicies);

        /**
         * <p>
         * The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
         * </p>
         * 
         * @param lbCookieStickinessPolicies
         *        The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lbCookieStickinessPolicies(LBCookieStickinessPolicy... lbCookieStickinessPolicies);

        /**
         * <p>
         * The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LBCookieStickinessPolicy>.Builder} avoiding
         * the need to create one manually via {@link List<LBCookieStickinessPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LBCookieStickinessPolicy>.Builder#build()} is called
         * immediately and its result is passed to {@link #lbCookieStickinessPolicies(List<LBCookieStickinessPolicy>)}.
         * 
         * @param lbCookieStickinessPolicies
         *        a consumer that will call methods on {@link List<LBCookieStickinessPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lbCookieStickinessPolicies(List<LBCookieStickinessPolicy>)
         */
        Builder lbCookieStickinessPolicies(Consumer<LBCookieStickinessPolicy.Builder>... lbCookieStickinessPolicies);

        /**
         * <p>
         * The policies other than the stickiness policies.
         * </p>
         * 
         * @param otherPolicies
         *        The policies other than the stickiness policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherPolicies(Collection<String> otherPolicies);

        /**
         * <p>
         * The policies other than the stickiness policies.
         * </p>
         * 
         * @param otherPolicies
         *        The policies other than the stickiness policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherPolicies(String... otherPolicies);
    }

    static final class BuilderImpl implements Builder {
        private List<AppCookieStickinessPolicy> appCookieStickinessPolicies = DefaultSdkAutoConstructList.getInstance();

        private List<LBCookieStickinessPolicy> lbCookieStickinessPolicies = DefaultSdkAutoConstructList.getInstance();

        private List<String> otherPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Policies model) {
            appCookieStickinessPolicies(model.appCookieStickinessPolicies);
            lbCookieStickinessPolicies(model.lbCookieStickinessPolicies);
            otherPolicies(model.otherPolicies);
        }

        public final Collection<AppCookieStickinessPolicy.Builder> getAppCookieStickinessPolicies() {
            return appCookieStickinessPolicies != null ? appCookieStickinessPolicies.stream()
                    .map(AppCookieStickinessPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder appCookieStickinessPolicies(Collection<AppCookieStickinessPolicy> appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies = AppCookieStickinessPoliciesCopier.copy(appCookieStickinessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appCookieStickinessPolicies(AppCookieStickinessPolicy... appCookieStickinessPolicies) {
            appCookieStickinessPolicies(Arrays.asList(appCookieStickinessPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appCookieStickinessPolicies(
                Consumer<AppCookieStickinessPolicy.Builder>... appCookieStickinessPolicies) {
            appCookieStickinessPolicies(Stream.of(appCookieStickinessPolicies)
                    .map(c -> AppCookieStickinessPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAppCookieStickinessPolicies(
                Collection<AppCookieStickinessPolicy.BuilderImpl> appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies = AppCookieStickinessPoliciesCopier.copyFromBuilder(appCookieStickinessPolicies);
        }

        public final Collection<LBCookieStickinessPolicy.Builder> getLbCookieStickinessPolicies() {
            return lbCookieStickinessPolicies != null ? lbCookieStickinessPolicies.stream()
                    .map(LBCookieStickinessPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lbCookieStickinessPolicies(Collection<LBCookieStickinessPolicy> lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies = LBCookieStickinessPoliciesCopier.copy(lbCookieStickinessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lbCookieStickinessPolicies(LBCookieStickinessPolicy... lbCookieStickinessPolicies) {
            lbCookieStickinessPolicies(Arrays.asList(lbCookieStickinessPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lbCookieStickinessPolicies(Consumer<LBCookieStickinessPolicy.Builder>... lbCookieStickinessPolicies) {
            lbCookieStickinessPolicies(Stream.of(lbCookieStickinessPolicies)
                    .map(c -> LBCookieStickinessPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLbCookieStickinessPolicies(
                Collection<LBCookieStickinessPolicy.BuilderImpl> lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies = LBCookieStickinessPoliciesCopier.copyFromBuilder(lbCookieStickinessPolicies);
        }

        public final Collection<String> getOtherPolicies() {
            return otherPolicies;
        }

        @Override
        public final Builder otherPolicies(Collection<String> otherPolicies) {
            this.otherPolicies = PolicyNamesCopier.copy(otherPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otherPolicies(String... otherPolicies) {
            otherPolicies(Arrays.asList(otherPolicies));
            return this;
        }

        public final void setOtherPolicies(Collection<String> otherPolicies) {
            this.otherPolicies = PolicyNamesCopier.copy(otherPolicies);
        }

        @Override
        public Policies build() {
            return new Policies(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
