/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of EnableAvailabilityZonesForLoadBalancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableAvailabilityZonesForLoadBalancerResponse extends ElasticLoadBalancingResponse implements
        ToCopyableBuilder<EnableAvailabilityZonesForLoadBalancerResponse.Builder, EnableAvailabilityZonesForLoadBalancerResponse> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EnableAvailabilityZonesForLoadBalancerResponse::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD));

    private final List<String> availabilityZones;

    private EnableAvailabilityZonesForLoadBalancerResponse(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated list of Availability Zones for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The updated list of Availability Zones for the load balancer.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZones());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAvailabilityZonesForLoadBalancerResponse)) {
            return false;
        }
        EnableAvailabilityZonesForLoadBalancerResponse other = (EnableAvailabilityZonesForLoadBalancerResponse) obj;
        return Objects.equals(availabilityZones(), other.availabilityZones());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EnableAvailabilityZonesForLoadBalancerResponse").add("AvailabilityZones", availabilityZones())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableAvailabilityZonesForLoadBalancerResponse, T> g) {
        return obj -> g.apply((EnableAvailabilityZonesForLoadBalancerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableAvailabilityZonesForLoadBalancerResponse> {
        /**
         * <p>
         * The updated list of Availability Zones for the load balancer.
         * </p>
         * 
         * @param availabilityZones
         *        The updated list of Availability Zones for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The updated list of Availability Zones for the load balancer.
         * </p>
         * 
         * @param availabilityZones
         *        The updated list of Availability Zones for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);
    }

    static final class BuilderImpl extends ElasticLoadBalancingResponse.BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAvailabilityZonesForLoadBalancerResponse model) {
            super(model);
            availabilityZones(model.availabilityZones);
        }

        public final Collection<String> getAvailabilityZones() {
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public EnableAvailabilityZonesForLoadBalancerResponse build() {
            return new EnableAvailabilityZonesForLoadBalancerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
