/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a policy type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyTypeDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyTypeDescription.Builder, PolicyTypeDescription> {
    private static final SdkField<String> POLICY_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PolicyTypeDescription::policyTypeName)).setter(setter(Builder::policyTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PolicyTypeDescription::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<PolicyAttributeTypeDescription>> POLICY_ATTRIBUTE_TYPE_DESCRIPTIONS_FIELD = SdkField
            .<List<PolicyAttributeTypeDescription>> builder(MarshallingType.LIST)
            .getter(getter(PolicyTypeDescription::policyAttributeTypeDescriptions))
            .setter(setter(Builder::policyAttributeTypeDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyAttributeTypeDescriptions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyAttributeTypeDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyAttributeTypeDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_NAME_FIELD,
            DESCRIPTION_FIELD, POLICY_ATTRIBUTE_TYPE_DESCRIPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyTypeName;

    private final String description;

    private final List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions;

    private PolicyTypeDescription(BuilderImpl builder) {
        this.policyTypeName = builder.policyTypeName;
        this.description = builder.description;
        this.policyAttributeTypeDescriptions = builder.policyAttributeTypeDescriptions;
    }

    /**
     * <p>
     * The name of the policy type.
     * </p>
     * 
     * @return The name of the policy type.
     */
    public String policyTypeName() {
        return policyTypeName;
    }

    /**
     * <p>
     * A description of the policy type.
     * </p>
     * 
     * @return A description of the policy type.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the PolicyAttributeTypeDescriptions property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasPolicyAttributeTypeDescriptions() {
        return policyAttributeTypeDescriptions != null && !(policyAttributeTypeDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The description of the policy attributes associated with the policies defined by Elastic Load Balancing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicyAttributeTypeDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The description of the policy attributes associated with the policies defined by Elastic Load Balancing.
     */
    public List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions() {
        return policyAttributeTypeDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(policyAttributeTypeDescriptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyTypeDescription)) {
            return false;
        }
        PolicyTypeDescription other = (PolicyTypeDescription) obj;
        return Objects.equals(policyTypeName(), other.policyTypeName()) && Objects.equals(description(), other.description())
                && Objects.equals(policyAttributeTypeDescriptions(), other.policyAttributeTypeDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PolicyTypeDescription").add("PolicyTypeName", policyTypeName())
                .add("Description", description()).add("PolicyAttributeTypeDescriptions", policyAttributeTypeDescriptions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyTypeName":
            return Optional.ofNullable(clazz.cast(policyTypeName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PolicyAttributeTypeDescriptions":
            return Optional.ofNullable(clazz.cast(policyAttributeTypeDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyTypeDescription, T> g) {
        return obj -> g.apply((PolicyTypeDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyTypeDescription> {
        /**
         * <p>
         * The name of the policy type.
         * </p>
         * 
         * @param policyTypeName
         *        The name of the policy type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypeName(String policyTypeName);

        /**
         * <p>
         * A description of the policy type.
         * </p>
         * 
         * @param description
         *        A description of the policy type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The description of the policy attributes associated with the policies defined by Elastic Load Balancing.
         * </p>
         * 
         * @param policyAttributeTypeDescriptions
         *        The description of the policy attributes associated with the policies defined by Elastic Load
         *        Balancing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyAttributeTypeDescriptions(Collection<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions);

        /**
         * <p>
         * The description of the policy attributes associated with the policies defined by Elastic Load Balancing.
         * </p>
         * 
         * @param policyAttributeTypeDescriptions
         *        The description of the policy attributes associated with the policies defined by Elastic Load
         *        Balancing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyAttributeTypeDescriptions(PolicyAttributeTypeDescription... policyAttributeTypeDescriptions);

        /**
         * <p>
         * The description of the policy attributes associated with the policies defined by Elastic Load Balancing.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyAttributeTypeDescription>.Builder}
         * avoiding the need to create one manually via {@link List<PolicyAttributeTypeDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyAttributeTypeDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #policyAttributeTypeDescriptions(List<PolicyAttributeTypeDescription>)}.
         * 
         * @param policyAttributeTypeDescriptions
         *        a consumer that will call methods on {@link List<PolicyAttributeTypeDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyAttributeTypeDescriptions(List<PolicyAttributeTypeDescription>)
         */
        Builder policyAttributeTypeDescriptions(
                Consumer<PolicyAttributeTypeDescription.Builder>... policyAttributeTypeDescriptions);
    }

    static final class BuilderImpl implements Builder {
        private String policyTypeName;

        private String description;

        private List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyTypeDescription model) {
            policyTypeName(model.policyTypeName);
            description(model.description);
            policyAttributeTypeDescriptions(model.policyAttributeTypeDescriptions);
        }

        public final String getPolicyTypeName() {
            return policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<PolicyAttributeTypeDescription.Builder> getPolicyAttributeTypeDescriptions() {
            return policyAttributeTypeDescriptions != null ? policyAttributeTypeDescriptions.stream()
                    .map(PolicyAttributeTypeDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyAttributeTypeDescriptions(
                Collection<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions = PolicyAttributeTypeDescriptionsCopier.copy(policyAttributeTypeDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeTypeDescriptions(PolicyAttributeTypeDescription... policyAttributeTypeDescriptions) {
            policyAttributeTypeDescriptions(Arrays.asList(policyAttributeTypeDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeTypeDescriptions(
                Consumer<PolicyAttributeTypeDescription.Builder>... policyAttributeTypeDescriptions) {
            policyAttributeTypeDescriptions(Stream.of(policyAttributeTypeDescriptions)
                    .map(c -> PolicyAttributeTypeDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyAttributeTypeDescriptions(
                Collection<PolicyAttributeTypeDescription.BuilderImpl> policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions = PolicyAttributeTypeDescriptionsCopier
                    .copyFromBuilder(policyAttributeTypeDescriptions);
        }

        @Override
        public PolicyTypeDescription build() {
            return new PolicyTypeDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
