/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a policy attribute type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyAttributeTypeDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyAttributeTypeDescription.Builder, PolicyAttributeTypeDescription> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PolicyAttributeTypeDescription::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PolicyAttributeTypeDescription::attributeType)).setter(setter(Builder::attributeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PolicyAttributeTypeDescription::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PolicyAttributeTypeDescription::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<String> CARDINALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PolicyAttributeTypeDescription::cardinality)).setter(setter(Builder::cardinality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cardinality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            ATTRIBUTE_TYPE_FIELD, DESCRIPTION_FIELD, DEFAULT_VALUE_FIELD, CARDINALITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String attributeType;

    private final String description;

    private final String defaultValue;

    private final String cardinality;

    private PolicyAttributeTypeDescription(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeType = builder.attributeType;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
        this.cardinality = builder.cardinality;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * 
     * @return The name of the attribute.
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The type of the attribute. For example, <code>Boolean</code> or <code>Integer</code>.
     * </p>
     * 
     * @return The type of the attribute. For example, <code>Boolean</code> or <code>Integer</code>.
     */
    public String attributeType() {
        return attributeType;
    }

    /**
     * <p>
     * A description of the attribute.
     * </p>
     * 
     * @return A description of the attribute.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The default value of the attribute, if applicable.
     * </p>
     * 
     * @return The default value of the attribute, if applicable.
     */
    public String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The cardinality of the attribute.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ONE(1) : Single value required
     * </p>
     * </li>
     * <li>
     * <p>
     * ZERO_OR_ONE(0..1) : Up to one value is allowed
     * </p>
     * </li>
     * <li>
     * <p>
     * ZERO_OR_MORE(0..*) : Optional. Multiple values are allowed
     * </p>
     * </li>
     * <li>
     * <p>
     * ONE_OR_MORE(1..*0) : Required. Multiple values are allowed
     * </p>
     * </li>
     * </ul>
     * 
     * @return The cardinality of the attribute.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ONE(1) : Single value required
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ZERO_OR_ONE(0..1) : Up to one value is allowed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ZERO_OR_MORE(0..*) : Optional. Multiple values are allowed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ONE_OR_MORE(1..*0) : Required. Multiple values are allowed
     *         </p>
     *         </li>
     */
    public String cardinality() {
        return cardinality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(cardinality());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyAttributeTypeDescription)) {
            return false;
        }
        PolicyAttributeTypeDescription other = (PolicyAttributeTypeDescription) obj;
        return Objects.equals(attributeName(), other.attributeName()) && Objects.equals(attributeType(), other.attributeType())
                && Objects.equals(description(), other.description()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(cardinality(), other.cardinality());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PolicyAttributeTypeDescription").add("AttributeName", attributeName())
                .add("AttributeType", attributeType()).add("Description", description()).add("DefaultValue", defaultValue())
                .add("Cardinality", cardinality()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "AttributeType":
            return Optional.ofNullable(clazz.cast(attributeType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "Cardinality":
            return Optional.ofNullable(clazz.cast(cardinality()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyAttributeTypeDescription, T> g) {
        return obj -> g.apply((PolicyAttributeTypeDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyAttributeTypeDescription> {
        /**
         * <p>
         * The name of the attribute.
         * </p>
         * 
         * @param attributeName
         *        The name of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The type of the attribute. For example, <code>Boolean</code> or <code>Integer</code>.
         * </p>
         * 
         * @param attributeType
         *        The type of the attribute. For example, <code>Boolean</code> or <code>Integer</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeType(String attributeType);

        /**
         * <p>
         * A description of the attribute.
         * </p>
         * 
         * @param description
         *        A description of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The default value of the attribute, if applicable.
         * </p>
         * 
         * @param defaultValue
         *        The default value of the attribute, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The cardinality of the attribute.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ONE(1) : Single value required
         * </p>
         * </li>
         * <li>
         * <p>
         * ZERO_OR_ONE(0..1) : Up to one value is allowed
         * </p>
         * </li>
         * <li>
         * <p>
         * ZERO_OR_MORE(0..*) : Optional. Multiple values are allowed
         * </p>
         * </li>
         * <li>
         * <p>
         * ONE_OR_MORE(1..*0) : Required. Multiple values are allowed
         * </p>
         * </li>
         * </ul>
         * 
         * @param cardinality
         *        The cardinality of the attribute.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ONE(1) : Single value required
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ZERO_OR_ONE(0..1) : Up to one value is allowed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ZERO_OR_MORE(0..*) : Optional. Multiple values are allowed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ONE_OR_MORE(1..*0) : Required. Multiple values are allowed
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardinality(String cardinality);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String attributeType;

        private String description;

        private String defaultValue;

        private String cardinality;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyAttributeTypeDescription model) {
            attributeName(model.attributeName);
            attributeType(model.attributeType);
            description(model.description);
            defaultValue(model.defaultValue);
            cardinality(model.cardinality);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeType() {
            return attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getCardinality() {
            return cardinality;
        }

        @Override
        public final Builder cardinality(String cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        public final void setCardinality(String cardinality) {
            this.cardinality = cardinality;
        }

        @Override
        public PolicyAttributeTypeDescription build() {
            return new PolicyAttributeTypeDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
