/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLoadBalancerListenersRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, CreateLoadBalancerListenersRequest> {
    private final String loadBalancerName;
    private final List<Listener> listeners;

    private CreateLoadBalancerListenersRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.listeners = builder.listeners;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public List<Listener> listeners() {
        return this.listeners;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.listeners());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerListenersRequest)) {
            return false;
        }
        CreateLoadBalancerListenersRequest other = (CreateLoadBalancerListenersRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.listeners(), other.listeners());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.listeners() != null) {
            sb.append("Listeners: ").append(this.listeners()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.of(clazz.cast(this.loadBalancerName()));
            }
            case "Listeners": {
                return Optional.of(clazz.cast(this.listeners()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<Listener> listeners;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerListenersRequest model) {
            this.loadBalancerName(model.loadBalancerName);
            this.listeners(model.listeners);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Collection<Listener.Builder> getListeners() {
            return this.listeners != null ? (Collection)this.listeners.stream().map(Listener::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener ... listeners) {
            this.listeners(Arrays.asList(listeners));
            return this;
        }

        public final void setListeners(Collection<Listener.BuilderImpl> listeners) {
            this.listeners = ListenersCopier.copyFromBuilder(listeners);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerListenersRequest build() {
            return new CreateLoadBalancerListenersRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    CopyableBuilder<Builder, CreateLoadBalancerListenersRequest> {
        public Builder loadBalancerName(String var1);

        public Builder listeners(Collection<Listener> var1);

        public Builder listeners(Listener ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

