/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancing.model.SubnetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachLoadBalancerToSubnetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, AttachLoadBalancerToSubnetsResponse> {
    private final List<String> subnets;

    private AttachLoadBalancerToSubnetsResponse(BuilderImpl builder) {
        this.subnets = builder.subnets;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachLoadBalancerToSubnetsResponse)) {
            return false;
        }
        AttachLoadBalancerToSubnetsResponse other = (AttachLoadBalancerToSubnetsResponse)((Object)obj);
        return Objects.equals(this.subnets(), other.subnets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subnets": {
                return Optional.of(clazz.cast(this.subnets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> subnets;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachLoadBalancerToSubnetsResponse model) {
            this.subnets(model.subnets);
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        public AttachLoadBalancerToSubnetsResponse build() {
            return new AttachLoadBalancerToSubnetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttachLoadBalancerToSubnetsResponse> {
        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);
    }
}

