/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Listener
implements ToCopyableBuilder<Builder, Listener> {
    private final String protocol;
    private final Integer loadBalancerPort;
    private final String instanceProtocol;
    private final Integer instancePort;
    private final String sslCertificateId;

    private Listener(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.loadBalancerPort = builder.loadBalancerPort;
        this.instanceProtocol = builder.instanceProtocol;
        this.instancePort = builder.instancePort;
        this.sslCertificateId = builder.sslCertificateId;
    }

    public String protocol() {
        return this.protocol;
    }

    public Integer loadBalancerPort() {
        return this.loadBalancerPort;
    }

    public String instanceProtocol() {
        return this.instanceProtocol;
    }

    public Integer instancePort() {
        return this.instancePort;
    }

    public String sslCertificateId() {
        return this.sslCertificateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        hashCode = 31 * hashCode + (this.loadBalancerPort() == null ? 0 : this.loadBalancerPort().hashCode());
        hashCode = 31 * hashCode + (this.instanceProtocol() == null ? 0 : this.instanceProtocol().hashCode());
        hashCode = 31 * hashCode + (this.instancePort() == null ? 0 : this.instancePort().hashCode());
        hashCode = 31 * hashCode + (this.sslCertificateId() == null ? 0 : this.sslCertificateId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener)obj;
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.loadBalancerPort() == null ^ this.loadBalancerPort() == null) {
            return false;
        }
        if (other.loadBalancerPort() != null && !other.loadBalancerPort().equals(this.loadBalancerPort())) {
            return false;
        }
        if (other.instanceProtocol() == null ^ this.instanceProtocol() == null) {
            return false;
        }
        if (other.instanceProtocol() != null && !other.instanceProtocol().equals(this.instanceProtocol())) {
            return false;
        }
        if (other.instancePort() == null ^ this.instancePort() == null) {
            return false;
        }
        if (other.instancePort() != null && !other.instancePort().equals(this.instancePort())) {
            return false;
        }
        if (other.sslCertificateId() == null ^ this.sslCertificateId() == null) {
            return false;
        }
        return other.sslCertificateId() == null || other.sslCertificateId().equals(this.sslCertificateId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        if (this.loadBalancerPort() != null) {
            sb.append("LoadBalancerPort: ").append(this.loadBalancerPort()).append(",");
        }
        if (this.instanceProtocol() != null) {
            sb.append("InstanceProtocol: ").append(this.instanceProtocol()).append(",");
        }
        if (this.instancePort() != null) {
            sb.append("InstancePort: ").append(this.instancePort()).append(",");
        }
        if (this.sslCertificateId() != null) {
            sb.append("SSLCertificateId: ").append(this.sslCertificateId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocol()));
            }
            case "LoadBalancerPort": {
                return Optional.of(clazz.cast(this.loadBalancerPort()));
            }
            case "InstanceProtocol": {
                return Optional.of(clazz.cast(this.instanceProtocol()));
            }
            case "InstancePort": {
                return Optional.of(clazz.cast(this.instancePort()));
            }
            case "SSLCertificateId": {
                return Optional.of(clazz.cast(this.sslCertificateId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private Integer loadBalancerPort;
        private String instanceProtocol;
        private Integer instancePort;
        private String sslCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(Listener model) {
            this.protocol(model.protocol);
            this.loadBalancerPort(model.loadBalancerPort);
            this.instanceProtocol(model.instanceProtocol);
            this.instancePort(model.instancePort);
            this.sslCertificateId(model.sslCertificateId);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getLoadBalancerPort() {
            return this.loadBalancerPort;
        }

        @Override
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        public final String getInstanceProtocol() {
            return this.instanceProtocol;
        }

        @Override
        public final Builder instanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
            return this;
        }

        public final void setInstanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
        }

        public final Integer getInstancePort() {
            return this.instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        public final String getSSLCertificateId() {
            return this.sslCertificateId;
        }

        @Override
        public final Builder sslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        public final void setSSLCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
        }

        public Listener build() {
            return new Listener(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Listener> {
        public Builder protocol(String var1);

        public Builder loadBalancerPort(Integer var1);

        public Builder instanceProtocol(String var1);

        public Builder instancePort(Integer var1);

        public Builder sslCertificateId(String var1);
    }
}

