/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConnectionDraining
implements ToCopyableBuilder<Builder, ConnectionDraining> {
    private final Boolean enabled;
    private final Integer timeout;

    private ConnectionDraining(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.timeout = builder.timeout;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.timeout() == null ? 0 : this.timeout().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionDraining)) {
            return false;
        }
        ConnectionDraining other = (ConnectionDraining)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.timeout() == null ^ this.timeout() == null) {
            return false;
        }
        return other.timeout() == null || other.timeout().equals(this.timeout());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.timeout() != null) {
            sb.append("Timeout: ").append(this.timeout()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "Timeout": {
                return Optional.of(clazz.cast(this.timeout()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionDraining model) {
            this.enabled(model.enabled);
            this.timeout(model.timeout);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public ConnectionDraining build() {
            return new ConnectionDraining(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConnectionDraining> {
        public Builder enabled(Boolean var1);

        public Builder timeout(Integer var1);
    }
}

