/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancing.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplySecurityGroupsToLoadBalancerResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ApplySecurityGroupsToLoadBalancerResponse> {
    private final List<String> securityGroups;

    private ApplySecurityGroupsToLoadBalancerResponse(BuilderImpl builder) {
        this.securityGroups = builder.securityGroups;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplySecurityGroupsToLoadBalancerResponse)) {
            return false;
        }
        ApplySecurityGroupsToLoadBalancerResponse other = (ApplySecurityGroupsToLoadBalancerResponse)((Object)obj);
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        return other.securityGroups() == null || other.securityGroups().equals(this.securityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplySecurityGroupsToLoadBalancerResponse model) {
            this.securityGroups(model.securityGroups);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public ApplySecurityGroupsToLoadBalancerResponse build() {
            return new ApplySecurityGroupsToLoadBalancerResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplySecurityGroupsToLoadBalancerResponse> {
        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);
    }
}

