/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest;
import software.amazon.awssdk.util.StringUtils;

public class SetLoadBalancerPoliciesForBackendServerRequestMarshaller
implements Marshaller<Request<SetLoadBalancerPoliciesForBackendServerRequest>, SetLoadBalancerPoliciesForBackendServerRequest> {
    public Request<SetLoadBalancerPoliciesForBackendServerRequest> marshall(SetLoadBalancerPoliciesForBackendServerRequest setLoadBalancerPoliciesForBackendServerRequest) {
        List<String> policyNamesList;
        if (setLoadBalancerPoliciesForBackendServerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setLoadBalancerPoliciesForBackendServerRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "SetLoadBalancerPoliciesForBackendServer");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setLoadBalancerPoliciesForBackendServerRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)setLoadBalancerPoliciesForBackendServerRequest.loadBalancerName()));
        }
        if (setLoadBalancerPoliciesForBackendServerRequest.instancePort() != null) {
            request.addParameter("InstancePort", StringUtils.fromInteger((Integer)setLoadBalancerPoliciesForBackendServerRequest.instancePort()));
        }
        if ((policyNamesList = setLoadBalancerPoliciesForBackendServerRequest.policyNames()) != null) {
            if (!policyNamesList.isEmpty()) {
                int policyNamesListIndex = 1;
                for (String policyNamesListValue : policyNamesList) {
                    if (policyNamesListValue != null) {
                        request.addParameter("PolicyNames.member." + policyNamesListIndex, StringUtils.fromString((String)policyNamesListValue));
                    }
                    ++policyNamesListIndex;
                }
            } else {
                request.addParameter("PolicyNames", "");
            }
        }
        return request;
    }
}

