/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute;

public class PolicyAttributeUnmarshaller
implements Unmarshaller<PolicyAttribute, StaxUnmarshallerContext> {
    private static final PolicyAttributeUnmarshaller INSTANCE = new PolicyAttributeUnmarshaller();

    public PolicyAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PolicyAttribute.Builder policyAttribute = PolicyAttribute.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AttributeName", targetDepth)) {
                    policyAttribute.attributeName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AttributeValue", targetDepth)) continue;
                policyAttribute.attributeValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PolicyAttribute)policyAttribute.build();
    }

    public static PolicyAttributeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

