/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticloadbalancing.model.AppCookieStickinessPoliciesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.AppCookieStickinessPolicy;
import software.amazon.awssdk.services.elasticloadbalancing.model.LBCookieStickinessPoliciesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.LBCookieStickinessPolicy;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Policies
implements ToCopyableBuilder<Builder, Policies> {
    private final List<AppCookieStickinessPolicy> appCookieStickinessPolicies;
    private final List<LBCookieStickinessPolicy> lbCookieStickinessPolicies;
    private final List<String> otherPolicies;

    private Policies(BuilderImpl builder) {
        this.appCookieStickinessPolicies = builder.appCookieStickinessPolicies;
        this.lbCookieStickinessPolicies = builder.lbCookieStickinessPolicies;
        this.otherPolicies = builder.otherPolicies;
    }

    public List<AppCookieStickinessPolicy> appCookieStickinessPolicies() {
        return this.appCookieStickinessPolicies;
    }

    public List<LBCookieStickinessPolicy> lbCookieStickinessPolicies() {
        return this.lbCookieStickinessPolicies;
    }

    public List<String> otherPolicies() {
        return this.otherPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.appCookieStickinessPolicies() == null ? 0 : this.appCookieStickinessPolicies().hashCode());
        hashCode = 31 * hashCode + (this.lbCookieStickinessPolicies() == null ? 0 : this.lbCookieStickinessPolicies().hashCode());
        hashCode = 31 * hashCode + (this.otherPolicies() == null ? 0 : this.otherPolicies().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policies)) {
            return false;
        }
        Policies other = (Policies)obj;
        if (other.appCookieStickinessPolicies() == null ^ this.appCookieStickinessPolicies() == null) {
            return false;
        }
        if (other.appCookieStickinessPolicies() != null && !other.appCookieStickinessPolicies().equals(this.appCookieStickinessPolicies())) {
            return false;
        }
        if (other.lbCookieStickinessPolicies() == null ^ this.lbCookieStickinessPolicies() == null) {
            return false;
        }
        if (other.lbCookieStickinessPolicies() != null && !other.lbCookieStickinessPolicies().equals(this.lbCookieStickinessPolicies())) {
            return false;
        }
        if (other.otherPolicies() == null ^ this.otherPolicies() == null) {
            return false;
        }
        return other.otherPolicies() == null || other.otherPolicies().equals(this.otherPolicies());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appCookieStickinessPolicies() != null) {
            sb.append("AppCookieStickinessPolicies: ").append(this.appCookieStickinessPolicies()).append(",");
        }
        if (this.lbCookieStickinessPolicies() != null) {
            sb.append("LBCookieStickinessPolicies: ").append(this.lbCookieStickinessPolicies()).append(",");
        }
        if (this.otherPolicies() != null) {
            sb.append("OtherPolicies: ").append(this.otherPolicies()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AppCookieStickinessPolicy> appCookieStickinessPolicies;
        private List<LBCookieStickinessPolicy> lbCookieStickinessPolicies;
        private List<String> otherPolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(Policies model) {
            this.setAppCookieStickinessPolicies(model.appCookieStickinessPolicies);
            this.setLBCookieStickinessPolicies(model.lbCookieStickinessPolicies);
            this.setOtherPolicies(model.otherPolicies);
        }

        public final Collection<AppCookieStickinessPolicy> getAppCookieStickinessPolicies() {
            return this.appCookieStickinessPolicies;
        }

        @Override
        public final Builder appCookieStickinessPolicies(Collection<AppCookieStickinessPolicy> appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies = AppCookieStickinessPoliciesCopier.copy(appCookieStickinessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appCookieStickinessPolicies(AppCookieStickinessPolicy ... appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies(Arrays.asList(appCookieStickinessPolicies));
            return this;
        }

        public final void setAppCookieStickinessPolicies(Collection<AppCookieStickinessPolicy> appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies = AppCookieStickinessPoliciesCopier.copy(appCookieStickinessPolicies);
        }

        public final Collection<LBCookieStickinessPolicy> getLBCookieStickinessPolicies() {
            return this.lbCookieStickinessPolicies;
        }

        @Override
        public final Builder lbCookieStickinessPolicies(Collection<LBCookieStickinessPolicy> lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies = LBCookieStickinessPoliciesCopier.copy(lbCookieStickinessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lbCookieStickinessPolicies(LBCookieStickinessPolicy ... lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies(Arrays.asList(lbCookieStickinessPolicies));
            return this;
        }

        public final void setLBCookieStickinessPolicies(Collection<LBCookieStickinessPolicy> lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies = LBCookieStickinessPoliciesCopier.copy(lbCookieStickinessPolicies);
        }

        public final Collection<String> getOtherPolicies() {
            return this.otherPolicies;
        }

        @Override
        public final Builder otherPolicies(Collection<String> otherPolicies) {
            this.otherPolicies = PolicyNamesCopier.copy(otherPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otherPolicies(String ... otherPolicies) {
            this.otherPolicies(Arrays.asList(otherPolicies));
            return this;
        }

        public final void setOtherPolicies(Collection<String> otherPolicies) {
            this.otherPolicies = PolicyNamesCopier.copy(otherPolicies);
        }

        public Policies build() {
            return new Policies(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Policies> {
        public Builder appCookieStickinessPolicies(Collection<AppCookieStickinessPolicy> var1);

        public Builder appCookieStickinessPolicies(AppCookieStickinessPolicy ... var1);

        public Builder lbCookieStickinessPolicies(Collection<LBCookieStickinessPolicy> var1);

        public Builder lbCookieStickinessPolicies(LBCookieStickinessPolicy ... var1);

        public Builder otherPolicies(Collection<String> var1);

        public Builder otherPolicies(String ... var1);
    }
}

