/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PortsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteLoadBalancerListenersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteLoadBalancerListenersRequest> {
    private final String loadBalancerName;
    private final List<Integer> loadBalancerPorts;

    private DeleteLoadBalancerListenersRequest(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerPorts = builder.loadBalancerPorts;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public List<Integer> loadBalancerPorts() {
        return this.loadBalancerPorts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.loadBalancerPorts() == null ? 0 : this.loadBalancerPorts().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLoadBalancerListenersRequest)) {
            return false;
        }
        DeleteLoadBalancerListenersRequest other = (DeleteLoadBalancerListenersRequest)((Object)obj);
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.loadBalancerPorts() == null ^ this.loadBalancerPorts() == null) {
            return false;
        }
        return other.loadBalancerPorts() == null || other.loadBalancerPorts().equals(this.loadBalancerPorts());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.loadBalancerPorts() != null) {
            sb.append("LoadBalancerPorts: ").append(this.loadBalancerPorts()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<Integer> loadBalancerPorts;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLoadBalancerListenersRequest model) {
            this.setLoadBalancerName(model.loadBalancerName);
            this.setLoadBalancerPorts(model.loadBalancerPorts);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Collection<Integer> getLoadBalancerPorts() {
            return this.loadBalancerPorts;
        }

        @Override
        public final Builder loadBalancerPorts(Collection<Integer> loadBalancerPorts) {
            this.loadBalancerPorts = PortsCopier.copy(loadBalancerPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerPorts(Integer ... loadBalancerPorts) {
            this.loadBalancerPorts(Arrays.asList(loadBalancerPorts));
            return this;
        }

        public final void setLoadBalancerPorts(Collection<Integer> loadBalancerPorts) {
            this.loadBalancerPorts = PortsCopier.copy(loadBalancerPorts);
        }

        public DeleteLoadBalancerListenersRequest build() {
            return new DeleteLoadBalancerListenersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteLoadBalancerListenersRequest> {
        public Builder loadBalancerName(String var1);

        public Builder loadBalancerPorts(Collection<Integer> var1);

        public Builder loadBalancerPorts(Integer ... var1);
    }
}

