/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccessLog
implements ToCopyableBuilder<Builder, AccessLog> {
    private final Boolean enabled;
    private final String s3BucketName;
    private final Integer emitInterval;
    private final String s3BucketPrefix;

    private AccessLog(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.s3BucketName = builder.s3BucketName;
        this.emitInterval = builder.emitInterval;
        this.s3BucketPrefix = builder.s3BucketPrefix;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public Integer emitInterval() {
        return this.emitInterval;
    }

    public String s3BucketPrefix() {
        return this.s3BucketPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.s3BucketName() == null ? 0 : this.s3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.emitInterval() == null ? 0 : this.emitInterval().hashCode());
        hashCode = 31 * hashCode + (this.s3BucketPrefix() == null ? 0 : this.s3BucketPrefix().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessLog)) {
            return false;
        }
        AccessLog other = (AccessLog)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.s3BucketName() == null ^ this.s3BucketName() == null) {
            return false;
        }
        if (other.s3BucketName() != null && !other.s3BucketName().equals(this.s3BucketName())) {
            return false;
        }
        if (other.emitInterval() == null ^ this.emitInterval() == null) {
            return false;
        }
        if (other.emitInterval() != null && !other.emitInterval().equals(this.emitInterval())) {
            return false;
        }
        if (other.s3BucketPrefix() == null ^ this.s3BucketPrefix() == null) {
            return false;
        }
        return other.s3BucketPrefix() == null || other.s3BucketPrefix().equals(this.s3BucketPrefix());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.s3BucketName() != null) {
            sb.append("S3BucketName: ").append(this.s3BucketName()).append(",");
        }
        if (this.emitInterval() != null) {
            sb.append("EmitInterval: ").append(this.emitInterval()).append(",");
        }
        if (this.s3BucketPrefix() != null) {
            sb.append("S3BucketPrefix: ").append(this.s3BucketPrefix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String s3BucketName;
        private Integer emitInterval;
        private String s3BucketPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessLog model) {
            this.setEnabled(model.enabled);
            this.setS3BucketName(model.s3BucketName);
            this.setEmitInterval(model.emitInterval);
            this.setS3BucketPrefix(model.s3BucketPrefix);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final Integer getEmitInterval() {
            return this.emitInterval;
        }

        @Override
        public final Builder emitInterval(Integer emitInterval) {
            this.emitInterval = emitInterval;
            return this;
        }

        public final void setEmitInterval(Integer emitInterval) {
            this.emitInterval = emitInterval;
        }

        public final String getS3BucketPrefix() {
            return this.s3BucketPrefix;
        }

        @Override
        public final Builder s3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
            return this;
        }

        public final void setS3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
        }

        public AccessLog build() {
            return new AccessLog(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccessLog> {
        public Builder enabled(Boolean var1);

        public Builder s3BucketName(String var1);

        public Builder emitInterval(Integer var1);

        public Builder s3BucketPrefix(String var1);
    }
}

