/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest;

public class DetachLoadBalancerFromSubnetsRequestMarshaller
implements Marshaller<Request<DetachLoadBalancerFromSubnetsRequest>, DetachLoadBalancerFromSubnetsRequest> {
    public Request<DetachLoadBalancerFromSubnetsRequest> marshall(DetachLoadBalancerFromSubnetsRequest detachLoadBalancerFromSubnetsRequest) {
        if (detachLoadBalancerFromSubnetsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)detachLoadBalancerFromSubnetsRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DetachLoadBalancerFromSubnets");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachLoadBalancerFromSubnetsRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)detachLoadBalancerFromSubnetsRequest.loadBalancerName()));
        }
        if (detachLoadBalancerFromSubnetsRequest.subnets().isEmpty() && !(detachLoadBalancerFromSubnetsRequest.subnets() instanceof SdkAutoConstructList)) {
            request.addParameter("Subnets", "");
        } else if (!detachLoadBalancerFromSubnetsRequest.subnets().isEmpty() && !(detachLoadBalancerFromSubnetsRequest.subnets() instanceof SdkAutoConstructList)) {
            List<String> subnetsList = detachLoadBalancerFromSubnetsRequest.subnets();
            int subnetsListIndex = 1;
            for (String subnetsListValue : subnetsList) {
                if (subnetsListValue != null) {
                    request.addParameter("Subnets.member." + subnetsListIndex, StringConversion.fromString((String)subnetsListValue));
                }
                ++subnetsListIndex;
            }
        }
        return request;
    }
}

