/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest;

public class AttachLoadBalancerToSubnetsRequestMarshaller
implements Marshaller<Request<AttachLoadBalancerToSubnetsRequest>, AttachLoadBalancerToSubnetsRequest> {
    public Request<AttachLoadBalancerToSubnetsRequest> marshall(AttachLoadBalancerToSubnetsRequest attachLoadBalancerToSubnetsRequest) {
        if (attachLoadBalancerToSubnetsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)attachLoadBalancerToSubnetsRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "AttachLoadBalancerToSubnets");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachLoadBalancerToSubnetsRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)attachLoadBalancerToSubnetsRequest.loadBalancerName()));
        }
        if (attachLoadBalancerToSubnetsRequest.subnets().isEmpty() && !(attachLoadBalancerToSubnetsRequest.subnets() instanceof SdkAutoConstructList)) {
            request.addParameter("Subnets", "");
        } else if (!attachLoadBalancerToSubnetsRequest.subnets().isEmpty() && !(attachLoadBalancerToSubnetsRequest.subnets() instanceof SdkAutoConstructList)) {
            List<String> subnetsList = attachLoadBalancerToSubnetsRequest.subnets();
            int subnetsListIndex = 1;
            for (String subnetsListValue : subnetsList) {
                if (subnetsListValue != null) {
                    request.addParameter("Subnets.member." + subnetsListIndex, StringConversion.fromString((String)subnetsListValue));
                }
                ++subnetsListIndex;
            }
        }
        return request;
    }
}

