/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.AccessLog;
import software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttribute;
import software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttributesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionDraining;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionSettings;
import software.amazon.awssdk.services.elasticloadbalancing.model.CrossZoneLoadBalancing;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerAttributes
implements ToCopyableBuilder<Builder, LoadBalancerAttributes> {
    private final CrossZoneLoadBalancing crossZoneLoadBalancing;
    private final AccessLog accessLog;
    private final ConnectionDraining connectionDraining;
    private final ConnectionSettings connectionSettings;
    private final List<AdditionalAttribute> additionalAttributes;

    private LoadBalancerAttributes(BuilderImpl builder) {
        this.crossZoneLoadBalancing = builder.crossZoneLoadBalancing;
        this.accessLog = builder.accessLog;
        this.connectionDraining = builder.connectionDraining;
        this.connectionSettings = builder.connectionSettings;
        this.additionalAttributes = builder.additionalAttributes;
    }

    public CrossZoneLoadBalancing crossZoneLoadBalancing() {
        return this.crossZoneLoadBalancing;
    }

    public AccessLog accessLog() {
        return this.accessLog;
    }

    public ConnectionDraining connectionDraining() {
        return this.connectionDraining;
    }

    public ConnectionSettings connectionSettings() {
        return this.connectionSettings;
    }

    public List<AdditionalAttribute> additionalAttributes() {
        return this.additionalAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crossZoneLoadBalancing());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionDraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerAttributes)) {
            return false;
        }
        LoadBalancerAttributes other = (LoadBalancerAttributes)obj;
        return Objects.equals(this.crossZoneLoadBalancing(), other.crossZoneLoadBalancing()) && Objects.equals(this.accessLog(), other.accessLog()) && Objects.equals(this.connectionDraining(), other.connectionDraining()) && Objects.equals(this.connectionSettings(), other.connectionSettings()) && Objects.equals(this.additionalAttributes(), other.additionalAttributes());
    }

    public String toString() {
        return ToString.builder((String)"LoadBalancerAttributes").add("CrossZoneLoadBalancing", (Object)this.crossZoneLoadBalancing()).add("AccessLog", (Object)this.accessLog()).add("ConnectionDraining", (Object)this.connectionDraining()).add("ConnectionSettings", (Object)this.connectionSettings()).add("AdditionalAttributes", this.additionalAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrossZoneLoadBalancing": {
                return Optional.ofNullable(clazz.cast(this.crossZoneLoadBalancing()));
            }
            case "AccessLog": {
                return Optional.ofNullable(clazz.cast(this.accessLog()));
            }
            case "ConnectionDraining": {
                return Optional.ofNullable(clazz.cast(this.connectionDraining()));
            }
            case "ConnectionSettings": {
                return Optional.ofNullable(clazz.cast(this.connectionSettings()));
            }
            case "AdditionalAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private CrossZoneLoadBalancing crossZoneLoadBalancing;
        private AccessLog accessLog;
        private ConnectionDraining connectionDraining;
        private ConnectionSettings connectionSettings;
        private List<AdditionalAttribute> additionalAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerAttributes model) {
            this.crossZoneLoadBalancing(model.crossZoneLoadBalancing);
            this.accessLog(model.accessLog);
            this.connectionDraining(model.connectionDraining);
            this.connectionSettings(model.connectionSettings);
            this.additionalAttributes(model.additionalAttributes);
        }

        public final CrossZoneLoadBalancing.Builder getCrossZoneLoadBalancing() {
            return this.crossZoneLoadBalancing != null ? this.crossZoneLoadBalancing.toBuilder() : null;
        }

        @Override
        public final Builder crossZoneLoadBalancing(CrossZoneLoadBalancing crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing;
            return this;
        }

        public final void setCrossZoneLoadBalancing(CrossZoneLoadBalancing.BuilderImpl crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing != null ? crossZoneLoadBalancing.build() : null;
        }

        public final AccessLog.Builder getAccessLog() {
            return this.accessLog != null ? this.accessLog.toBuilder() : null;
        }

        @Override
        public final Builder accessLog(AccessLog accessLog) {
            this.accessLog = accessLog;
            return this;
        }

        public final void setAccessLog(AccessLog.BuilderImpl accessLog) {
            this.accessLog = accessLog != null ? accessLog.build() : null;
        }

        public final ConnectionDraining.Builder getConnectionDraining() {
            return this.connectionDraining != null ? this.connectionDraining.toBuilder() : null;
        }

        @Override
        public final Builder connectionDraining(ConnectionDraining connectionDraining) {
            this.connectionDraining = connectionDraining;
            return this;
        }

        public final void setConnectionDraining(ConnectionDraining.BuilderImpl connectionDraining) {
            this.connectionDraining = connectionDraining != null ? connectionDraining.build() : null;
        }

        public final ConnectionSettings.Builder getConnectionSettings() {
            return this.connectionSettings != null ? this.connectionSettings.toBuilder() : null;
        }

        @Override
        public final Builder connectionSettings(ConnectionSettings connectionSettings) {
            this.connectionSettings = connectionSettings;
            return this;
        }

        public final void setConnectionSettings(ConnectionSettings.BuilderImpl connectionSettings) {
            this.connectionSettings = connectionSettings != null ? connectionSettings.build() : null;
        }

        public final Collection<AdditionalAttribute.Builder> getAdditionalAttributes() {
            return this.additionalAttributes != null ? (Collection)this.additionalAttributes.stream().map(AdditionalAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalAttributes(Collection<AdditionalAttribute> additionalAttributes) {
            this.additionalAttributes = AdditionalAttributesCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(AdditionalAttribute ... additionalAttributes) {
            this.additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(Consumer<AdditionalAttribute.Builder> ... additionalAttributes) {
            this.additionalAttributes(Stream.of(additionalAttributes).map(c -> (AdditionalAttribute)((AdditionalAttribute.Builder)AdditionalAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalAttributes(Collection<AdditionalAttribute.BuilderImpl> additionalAttributes) {
            this.additionalAttributes = AdditionalAttributesCopier.copyFromBuilder(additionalAttributes);
        }

        public LoadBalancerAttributes build() {
            return new LoadBalancerAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerAttributes> {
        public Builder crossZoneLoadBalancing(CrossZoneLoadBalancing var1);

        default public Builder crossZoneLoadBalancing(Consumer<CrossZoneLoadBalancing.Builder> crossZoneLoadBalancing) {
            return this.crossZoneLoadBalancing((CrossZoneLoadBalancing)((CrossZoneLoadBalancing.Builder)CrossZoneLoadBalancing.builder().applyMutation(crossZoneLoadBalancing)).build());
        }

        public Builder accessLog(AccessLog var1);

        default public Builder accessLog(Consumer<AccessLog.Builder> accessLog) {
            return this.accessLog((AccessLog)((AccessLog.Builder)AccessLog.builder().applyMutation(accessLog)).build());
        }

        public Builder connectionDraining(ConnectionDraining var1);

        default public Builder connectionDraining(Consumer<ConnectionDraining.Builder> connectionDraining) {
            return this.connectionDraining((ConnectionDraining)((ConnectionDraining.Builder)ConnectionDraining.builder().applyMutation(connectionDraining)).build());
        }

        public Builder connectionSettings(ConnectionSettings var1);

        default public Builder connectionSettings(Consumer<ConnectionSettings.Builder> connectionSettings) {
            return this.connectionSettings((ConnectionSettings)((ConnectionSettings.Builder)ConnectionSettings.builder().applyMutation(connectionSettings)).build());
        }

        public Builder additionalAttributes(Collection<AdditionalAttribute> var1);

        public Builder additionalAttributes(AdditionalAttribute ... var1);

        public Builder additionalAttributes(Consumer<AdditionalAttribute.Builder> ... var1);
    }
}

