/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest;

public class SetLoadBalancerPoliciesForBackendServerRequestMarshaller
implements Marshaller<Request<SetLoadBalancerPoliciesForBackendServerRequest>, SetLoadBalancerPoliciesForBackendServerRequest> {
    public Request<SetLoadBalancerPoliciesForBackendServerRequest> marshall(SetLoadBalancerPoliciesForBackendServerRequest setLoadBalancerPoliciesForBackendServerRequest) {
        if (setLoadBalancerPoliciesForBackendServerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setLoadBalancerPoliciesForBackendServerRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "SetLoadBalancerPoliciesForBackendServer");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setLoadBalancerPoliciesForBackendServerRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)setLoadBalancerPoliciesForBackendServerRequest.loadBalancerName()));
        }
        if (setLoadBalancerPoliciesForBackendServerRequest.instancePort() != null) {
            request.addParameter("InstancePort", StringConversion.fromInteger((Integer)setLoadBalancerPoliciesForBackendServerRequest.instancePort()));
        }
        if (setLoadBalancerPoliciesForBackendServerRequest.policyNames().isEmpty() && !(setLoadBalancerPoliciesForBackendServerRequest.policyNames() instanceof SdkAutoConstructList)) {
            request.addParameter("PolicyNames", "");
        } else if (!setLoadBalancerPoliciesForBackendServerRequest.policyNames().isEmpty() && !(setLoadBalancerPoliciesForBackendServerRequest.policyNames() instanceof SdkAutoConstructList)) {
            List<String> policyNamesList = setLoadBalancerPoliciesForBackendServerRequest.policyNames();
            int policyNamesListIndex = 1;
            for (String policyNamesListValue : policyNamesList) {
                if (policyNamesListValue != null) {
                    request.addParameter("PolicyNames.member." + policyNamesListIndex, StringConversion.fromString((String)policyNamesListValue));
                }
                ++policyNamesListIndex;
            }
        }
        return request;
    }
}

