/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;

public class DeleteLoadBalancerListenersRequestMarshaller
implements Marshaller<Request<DeleteLoadBalancerListenersRequest>, DeleteLoadBalancerListenersRequest> {
    public Request<DeleteLoadBalancerListenersRequest> marshall(DeleteLoadBalancerListenersRequest deleteLoadBalancerListenersRequest) {
        if (deleteLoadBalancerListenersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteLoadBalancerListenersRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DeleteLoadBalancerListeners");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteLoadBalancerListenersRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)deleteLoadBalancerListenersRequest.loadBalancerName()));
        }
        if (deleteLoadBalancerListenersRequest.loadBalancerPorts().isEmpty() && !(deleteLoadBalancerListenersRequest.loadBalancerPorts() instanceof SdkAutoConstructList)) {
            request.addParameter("LoadBalancerPorts", "");
        } else if (!deleteLoadBalancerListenersRequest.loadBalancerPorts().isEmpty() && !(deleteLoadBalancerListenersRequest.loadBalancerPorts() instanceof SdkAutoConstructList)) {
            List<Integer> loadBalancerPortsList = deleteLoadBalancerListenersRequest.loadBalancerPorts();
            int loadBalancerPortsListIndex = 1;
            for (Integer loadBalancerPortsListValue : loadBalancerPortsList) {
                if (loadBalancerPortsListValue != null) {
                    request.addParameter("LoadBalancerPorts.member." + loadBalancerPortsListIndex, StringConversion.fromInteger((Integer)loadBalancerPortsListValue));
                }
                ++loadBalancerPortsListIndex;
            }
        }
        return request;
    }
}

