/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancing.model.Tag;

public class CreateLoadBalancerRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerRequest>, CreateLoadBalancerRequest> {
    public Request<CreateLoadBalancerRequest> marshall(CreateLoadBalancerRequest createLoadBalancerRequest) {
        if (createLoadBalancerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createLoadBalancerRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "CreateLoadBalancer");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)createLoadBalancerRequest.loadBalancerName()));
        }
        if (createLoadBalancerRequest.listeners().isEmpty() && !(createLoadBalancerRequest.listeners() instanceof SdkAutoConstructList)) {
            request.addParameter("Listeners", "");
        } else if (!createLoadBalancerRequest.listeners().isEmpty() && !(createLoadBalancerRequest.listeners() instanceof SdkAutoConstructList)) {
            List<Listener> listenersList = createLoadBalancerRequest.listeners();
            int listenersListIndex = 1;
            for (Listener listenersListValue : listenersList) {
                if (listenersListValue.protocol() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".Protocol", StringConversion.fromString((String)listenersListValue.protocol()));
                }
                if (listenersListValue.loadBalancerPort() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".LoadBalancerPort", StringConversion.fromInteger((Integer)listenersListValue.loadBalancerPort()));
                }
                if (listenersListValue.instanceProtocol() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".InstanceProtocol", StringConversion.fromString((String)listenersListValue.instanceProtocol()));
                }
                if (listenersListValue.instancePort() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".InstancePort", StringConversion.fromInteger((Integer)listenersListValue.instancePort()));
                }
                if (listenersListValue.sslCertificateId() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".SSLCertificateId", StringConversion.fromString((String)listenersListValue.sslCertificateId()));
                }
                ++listenersListIndex;
            }
        }
        if (createLoadBalancerRequest.availabilityZones().isEmpty() && !(createLoadBalancerRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            request.addParameter("AvailabilityZones", "");
        } else if (!createLoadBalancerRequest.availabilityZones().isEmpty() && !(createLoadBalancerRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            List<String> availabilityZonesList = createLoadBalancerRequest.availabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringConversion.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (createLoadBalancerRequest.subnets().isEmpty() && !(createLoadBalancerRequest.subnets() instanceof SdkAutoConstructList)) {
            request.addParameter("Subnets", "");
        } else if (!createLoadBalancerRequest.subnets().isEmpty() && !(createLoadBalancerRequest.subnets() instanceof SdkAutoConstructList)) {
            List<String> subnetsList = createLoadBalancerRequest.subnets();
            int subnetsListIndex = 1;
            for (String subnetsListValue : subnetsList) {
                if (subnetsListValue != null) {
                    request.addParameter("Subnets.member." + subnetsListIndex, StringConversion.fromString((String)subnetsListValue));
                }
                ++subnetsListIndex;
            }
        }
        if (createLoadBalancerRequest.securityGroups().isEmpty() && !(createLoadBalancerRequest.securityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("SecurityGroups", "");
        } else if (!createLoadBalancerRequest.securityGroups().isEmpty() && !(createLoadBalancerRequest.securityGroups() instanceof SdkAutoConstructList)) {
            List<String> securityGroupsList = createLoadBalancerRequest.securityGroups();
            int securityGroupsListIndex = 1;
            for (String securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringConversion.fromString((String)securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (createLoadBalancerRequest.scheme() != null) {
            request.addParameter("Scheme", StringConversion.fromString((String)createLoadBalancerRequest.scheme()));
        }
        if (createLoadBalancerRequest.tags().isEmpty() && !(createLoadBalancerRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createLoadBalancerRequest.tags().isEmpty() && !(createLoadBalancerRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createLoadBalancerRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

