/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.Listener;

public class CreateLoadBalancerListenersRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerListenersRequest>, CreateLoadBalancerListenersRequest> {
    public Request<CreateLoadBalancerListenersRequest> marshall(CreateLoadBalancerListenersRequest createLoadBalancerListenersRequest) {
        if (createLoadBalancerListenersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createLoadBalancerListenersRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "CreateLoadBalancerListeners");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerListenersRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)createLoadBalancerListenersRequest.loadBalancerName()));
        }
        if (createLoadBalancerListenersRequest.listeners().isEmpty() && !(createLoadBalancerListenersRequest.listeners() instanceof SdkAutoConstructList)) {
            request.addParameter("Listeners", "");
        } else if (!createLoadBalancerListenersRequest.listeners().isEmpty() && !(createLoadBalancerListenersRequest.listeners() instanceof SdkAutoConstructList)) {
            List<Listener> listenersList = createLoadBalancerListenersRequest.listeners();
            int listenersListIndex = 1;
            for (Listener listenersListValue : listenersList) {
                if (listenersListValue.protocol() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".Protocol", StringConversion.fromString((String)listenersListValue.protocol()));
                }
                if (listenersListValue.loadBalancerPort() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".LoadBalancerPort", StringConversion.fromInteger((Integer)listenersListValue.loadBalancerPort()));
                }
                if (listenersListValue.instanceProtocol() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".InstanceProtocol", StringConversion.fromString((String)listenersListValue.instanceProtocol()));
                }
                if (listenersListValue.instancePort() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".InstancePort", StringConversion.fromInteger((Integer)listenersListValue.instancePort()));
                }
                if (listenersListValue.sslCertificateId() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".SSLCertificateId", StringConversion.fromString((String)listenersListValue.sslCertificateId()));
                }
                ++listenersListIndex;
            }
        }
        return request;
    }
}

