/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;

public class DeleteLoadBalancerListenersRequestMarshaller
implements Marshaller<Request<DeleteLoadBalancerListenersRequest>, DeleteLoadBalancerListenersRequest> {
    public Request<DeleteLoadBalancerListenersRequest> marshall(DeleteLoadBalancerListenersRequest deleteLoadBalancerListenersRequest) {
        List<Integer> loadBalancerPortsList;
        if (deleteLoadBalancerListenersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteLoadBalancerListenersRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DeleteLoadBalancerListeners");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteLoadBalancerListenersRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)deleteLoadBalancerListenersRequest.loadBalancerName()));
        }
        if ((loadBalancerPortsList = deleteLoadBalancerListenersRequest.loadBalancerPorts()) != null) {
            if (!loadBalancerPortsList.isEmpty()) {
                int loadBalancerPortsListIndex = 1;
                for (Integer loadBalancerPortsListValue : loadBalancerPortsList) {
                    if (loadBalancerPortsListValue != null) {
                        request.addParameter("LoadBalancerPorts.member." + loadBalancerPortsListIndex, StringUtils.fromInteger((Integer)loadBalancerPortsListValue));
                    }
                    ++loadBalancerPortsListIndex;
                }
            } else {
                request.addParameter("LoadBalancerPorts", "");
            }
        }
        return request;
    }
}

