/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingClient;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription;

public class DescribeLoadBalancersIterable
implements SdkIterable<DescribeLoadBalancersResponse> {
    private final ElasticLoadBalancingClient client;
    private final DescribeLoadBalancersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLoadBalancersIterable(ElasticLoadBalancingClient client, DescribeLoadBalancersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeLoadBalancersResponseFetcher();
    }

    public Iterator<DescribeLoadBalancersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<LoadBalancerDescription> loadBalancerDescriptions() {
        Function<DescribeLoadBalancersResponse, Iterator> getIterator = response -> {
            if (response != null && response.loadBalancerDescriptions() != null) {
                return response.loadBalancerDescriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeLoadBalancersIterable resume(DescribeLoadBalancersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeLoadBalancersIterable(this.client, (DescribeLoadBalancersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new DescribeLoadBalancersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeLoadBalancersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeLoadBalancersResponseFetcher
    implements SyncPageFetcher<DescribeLoadBalancersResponse> {
        private DescribeLoadBalancersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLoadBalancersResponse previousPage) {
            return previousPage.nextMarker() != null;
        }

        public DescribeLoadBalancersResponse nextPage(DescribeLoadBalancersResponse previousPage) {
            if (previousPage == null) {
                return DescribeLoadBalancersIterable.this.client.describeLoadBalancers(DescribeLoadBalancersIterable.this.firstRequest);
            }
            return DescribeLoadBalancersIterable.this.client.describeLoadBalancers((DescribeLoadBalancersRequest)((Object)DescribeLoadBalancersIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

