/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PolicyTypeDescription
implements ToCopyableBuilder<Builder, PolicyTypeDescription> {
    private final String policyTypeName;
    private final String description;
    private final List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions;

    private PolicyTypeDescription(BuilderImpl builder) {
        this.policyTypeName = builder.policyTypeName;
        this.description = builder.description;
        this.policyAttributeTypeDescriptions = builder.policyAttributeTypeDescriptions;
    }

    public String policyTypeName() {
        return this.policyTypeName;
    }

    public String description() {
        return this.description;
    }

    public List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions() {
        return this.policyAttributeTypeDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyAttributeTypeDescriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyTypeDescription)) {
            return false;
        }
        PolicyTypeDescription other = (PolicyTypeDescription)obj;
        return Objects.equals(this.policyTypeName(), other.policyTypeName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.policyAttributeTypeDescriptions(), other.policyAttributeTypeDescriptions());
    }

    public String toString() {
        return ToString.builder((String)"PolicyTypeDescription").add("PolicyTypeName", (Object)this.policyTypeName()).add("Description", (Object)this.description()).add("PolicyAttributeTypeDescriptions", this.policyAttributeTypeDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyTypeName": {
                return Optional.of(clazz.cast(this.policyTypeName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "PolicyAttributeTypeDescriptions": {
                return Optional.of(clazz.cast(this.policyAttributeTypeDescriptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String policyTypeName;
        private String description;
        private List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyTypeDescription model) {
            this.policyTypeName(model.policyTypeName);
            this.description(model.description);
            this.policyAttributeTypeDescriptions(model.policyAttributeTypeDescriptions);
        }

        public final String getPolicyTypeName() {
            return this.policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<PolicyAttributeTypeDescription.Builder> getPolicyAttributeTypeDescriptions() {
            return this.policyAttributeTypeDescriptions != null ? (Collection)this.policyAttributeTypeDescriptions.stream().map(PolicyAttributeTypeDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyAttributeTypeDescriptions(Collection<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions = PolicyAttributeTypeDescriptionsCopier.copy(policyAttributeTypeDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeTypeDescriptions(PolicyAttributeTypeDescription ... policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions(Arrays.asList(policyAttributeTypeDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeTypeDescriptions(Consumer<PolicyAttributeTypeDescription.Builder> ... policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions(Stream.of(policyAttributeTypeDescriptions).map(c -> (PolicyAttributeTypeDescription)((PolicyAttributeTypeDescription.Builder)PolicyAttributeTypeDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyAttributeTypeDescriptions(Collection<PolicyAttributeTypeDescription.BuilderImpl> policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions = PolicyAttributeTypeDescriptionsCopier.copyFromBuilder(policyAttributeTypeDescriptions);
        }

        public PolicyTypeDescription build() {
            return new PolicyTypeDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyTypeDescription> {
        public Builder policyTypeName(String var1);

        public Builder description(String var1);

        public Builder policyAttributeTypeDescriptions(Collection<PolicyAttributeTypeDescription> var1);

        public Builder policyAttributeTypeDescriptions(PolicyAttributeTypeDescription ... var1);

        public Builder policyAttributeTypeDescriptions(Consumer<PolicyAttributeTypeDescription.Builder> ... var1);
    }
}

