/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyLoadBalancerAttributesResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, ModifyLoadBalancerAttributesResponse> {
    private final String loadBalancerName;
    private final LoadBalancerAttributes loadBalancerAttributes;

    private ModifyLoadBalancerAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerAttributes = builder.loadBalancerAttributes;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public LoadBalancerAttributes loadBalancerAttributes() {
        return this.loadBalancerAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLoadBalancerAttributesResponse)) {
            return false;
        }
        ModifyLoadBalancerAttributesResponse other = (ModifyLoadBalancerAttributesResponse)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.loadBalancerAttributes(), other.loadBalancerAttributes());
    }

    public String toString() {
        return ToString.builder((String)"ModifyLoadBalancerAttributesResponse").add("LoadBalancerName", (Object)this.loadBalancerName()).add("LoadBalancerAttributes", (Object)this.loadBalancerAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.of(clazz.cast(this.loadBalancerName()));
            }
            case "LoadBalancerAttributes": {
                return Optional.of(clazz.cast(this.loadBalancerAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private LoadBalancerAttributes loadBalancerAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLoadBalancerAttributesResponse model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.loadBalancerAttributes(model.loadBalancerAttributes);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final LoadBalancerAttributes.Builder getLoadBalancerAttributes() {
            return this.loadBalancerAttributes != null ? this.loadBalancerAttributes.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancerAttributes(LoadBalancerAttributes loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes;
            return this;
        }

        public final void setLoadBalancerAttributes(LoadBalancerAttributes.BuilderImpl loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes != null ? loadBalancerAttributes.build() : null;
        }

        @Override
        public ModifyLoadBalancerAttributesResponse build() {
            return new ModifyLoadBalancerAttributesResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    CopyableBuilder<Builder, ModifyLoadBalancerAttributesResponse> {
        public Builder loadBalancerName(String var1);

        public Builder loadBalancerAttributes(LoadBalancerAttributes var1);

        default public Builder loadBalancerAttributes(Consumer<LoadBalancerAttributes.Builder> loadBalancerAttributes) {
            return this.loadBalancerAttributes((LoadBalancerAttributes)((LoadBalancerAttributes.Builder)LoadBalancerAttributes.builder().apply(loadBalancerAttributes)).build());
        }
    }
}

