/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLoadBalancerPolicyRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, CreateLoadBalancerPolicyRequest> {
    private final String loadBalancerName;
    private final String policyName;
    private final String policyTypeName;
    private final List<PolicyAttribute> policyAttributes;

    private CreateLoadBalancerPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.policyName = builder.policyName;
        this.policyTypeName = builder.policyTypeName;
        this.policyAttributes = builder.policyAttributes;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyTypeName() {
        return this.policyTypeName;
    }

    public List<PolicyAttribute> policyAttributes() {
        return this.policyAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerPolicyRequest)) {
            return false;
        }
        CreateLoadBalancerPolicyRequest other = (CreateLoadBalancerPolicyRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyTypeName(), other.policyTypeName()) && Objects.equals(this.policyAttributes(), other.policyAttributes());
    }

    public String toString() {
        return ToString.builder((String)"CreateLoadBalancerPolicyRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("PolicyName", (Object)this.policyName()).add("PolicyTypeName", (Object)this.policyTypeName()).add("PolicyAttributes", this.policyAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.of(clazz.cast(this.loadBalancerName()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "PolicyTypeName": {
                return Optional.of(clazz.cast(this.policyTypeName()));
            }
            case "PolicyAttributes": {
                return Optional.of(clazz.cast(this.policyAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String policyName;
        private String policyTypeName;
        private List<PolicyAttribute> policyAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerPolicyRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.policyName(model.policyName);
            this.policyTypeName(model.policyTypeName);
            this.policyAttributes(model.policyAttributes);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyTypeName() {
            return this.policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        public final Collection<PolicyAttribute.Builder> getPolicyAttributes() {
            return this.policyAttributes != null ? (Collection)this.policyAttributes.stream().map(PolicyAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyAttributes(Collection<PolicyAttribute> policyAttributes) {
            this.policyAttributes = PolicyAttributesCopier.copy(policyAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributes(PolicyAttribute ... policyAttributes) {
            this.policyAttributes(Arrays.asList(policyAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributes(Consumer<PolicyAttribute.Builder> ... policyAttributes) {
            this.policyAttributes(Stream.of(policyAttributes).map(c -> (PolicyAttribute)((PolicyAttribute.Builder)PolicyAttribute.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyAttributes(Collection<PolicyAttribute.BuilderImpl> policyAttributes) {
            this.policyAttributes = PolicyAttributesCopier.copyFromBuilder(policyAttributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerPolicyRequest build() {
            return new CreateLoadBalancerPolicyRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    CopyableBuilder<Builder, CreateLoadBalancerPolicyRequest> {
        public Builder loadBalancerName(String var1);

        public Builder policyName(String var1);

        public Builder policyTypeName(String var1);

        public Builder policyAttributes(Collection<PolicyAttribute> var1);

        public Builder policyAttributes(PolicyAttribute ... var1);

        public Builder policyAttributes(Consumer<PolicyAttribute.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

