/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticloadbalancing.model.AccessLog;
import software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttribute;
import software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttributesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionDraining;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionSettings;
import software.amazon.awssdk.services.elasticloadbalancing.model.CrossZoneLoadBalancing;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadBalancerAttributes
implements ToCopyableBuilder<Builder, LoadBalancerAttributes> {
    private final CrossZoneLoadBalancing crossZoneLoadBalancing;
    private final AccessLog accessLog;
    private final ConnectionDraining connectionDraining;
    private final ConnectionSettings connectionSettings;
    private final List<AdditionalAttribute> additionalAttributes;

    private LoadBalancerAttributes(BuilderImpl builder) {
        this.crossZoneLoadBalancing = builder.crossZoneLoadBalancing;
        this.accessLog = builder.accessLog;
        this.connectionDraining = builder.connectionDraining;
        this.connectionSettings = builder.connectionSettings;
        this.additionalAttributes = builder.additionalAttributes;
    }

    public CrossZoneLoadBalancing crossZoneLoadBalancing() {
        return this.crossZoneLoadBalancing;
    }

    public AccessLog accessLog() {
        return this.accessLog;
    }

    public ConnectionDraining connectionDraining() {
        return this.connectionDraining;
    }

    public ConnectionSettings connectionSettings() {
        return this.connectionSettings;
    }

    public List<AdditionalAttribute> additionalAttributes() {
        return this.additionalAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.crossZoneLoadBalancing() == null ? 0 : this.crossZoneLoadBalancing().hashCode());
        hashCode = 31 * hashCode + (this.accessLog() == null ? 0 : this.accessLog().hashCode());
        hashCode = 31 * hashCode + (this.connectionDraining() == null ? 0 : this.connectionDraining().hashCode());
        hashCode = 31 * hashCode + (this.connectionSettings() == null ? 0 : this.connectionSettings().hashCode());
        hashCode = 31 * hashCode + (this.additionalAttributes() == null ? 0 : this.additionalAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerAttributes)) {
            return false;
        }
        LoadBalancerAttributes other = (LoadBalancerAttributes)obj;
        if (other.crossZoneLoadBalancing() == null ^ this.crossZoneLoadBalancing() == null) {
            return false;
        }
        if (other.crossZoneLoadBalancing() != null && !other.crossZoneLoadBalancing().equals(this.crossZoneLoadBalancing())) {
            return false;
        }
        if (other.accessLog() == null ^ this.accessLog() == null) {
            return false;
        }
        if (other.accessLog() != null && !other.accessLog().equals(this.accessLog())) {
            return false;
        }
        if (other.connectionDraining() == null ^ this.connectionDraining() == null) {
            return false;
        }
        if (other.connectionDraining() != null && !other.connectionDraining().equals(this.connectionDraining())) {
            return false;
        }
        if (other.connectionSettings() == null ^ this.connectionSettings() == null) {
            return false;
        }
        if (other.connectionSettings() != null && !other.connectionSettings().equals(this.connectionSettings())) {
            return false;
        }
        if (other.additionalAttributes() == null ^ this.additionalAttributes() == null) {
            return false;
        }
        return other.additionalAttributes() == null || other.additionalAttributes().equals(this.additionalAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.crossZoneLoadBalancing() != null) {
            sb.append("CrossZoneLoadBalancing: ").append(this.crossZoneLoadBalancing()).append(",");
        }
        if (this.accessLog() != null) {
            sb.append("AccessLog: ").append(this.accessLog()).append(",");
        }
        if (this.connectionDraining() != null) {
            sb.append("ConnectionDraining: ").append(this.connectionDraining()).append(",");
        }
        if (this.connectionSettings() != null) {
            sb.append("ConnectionSettings: ").append(this.connectionSettings()).append(",");
        }
        if (this.additionalAttributes() != null) {
            sb.append("AdditionalAttributes: ").append(this.additionalAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private CrossZoneLoadBalancing crossZoneLoadBalancing;
        private AccessLog accessLog;
        private ConnectionDraining connectionDraining;
        private ConnectionSettings connectionSettings;
        private List<AdditionalAttribute> additionalAttributes = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerAttributes model) {
            this.setCrossZoneLoadBalancing(model.crossZoneLoadBalancing);
            this.setAccessLog(model.accessLog);
            this.setConnectionDraining(model.connectionDraining);
            this.setConnectionSettings(model.connectionSettings);
            this.setAdditionalAttributes(model.additionalAttributes);
        }

        public final CrossZoneLoadBalancing getCrossZoneLoadBalancing() {
            return this.crossZoneLoadBalancing;
        }

        @Override
        public final Builder crossZoneLoadBalancing(CrossZoneLoadBalancing crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing;
            return this;
        }

        public final void setCrossZoneLoadBalancing(CrossZoneLoadBalancing crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing;
        }

        public final AccessLog getAccessLog() {
            return this.accessLog;
        }

        @Override
        public final Builder accessLog(AccessLog accessLog) {
            this.accessLog = accessLog;
            return this;
        }

        public final void setAccessLog(AccessLog accessLog) {
            this.accessLog = accessLog;
        }

        public final ConnectionDraining getConnectionDraining() {
            return this.connectionDraining;
        }

        @Override
        public final Builder connectionDraining(ConnectionDraining connectionDraining) {
            this.connectionDraining = connectionDraining;
            return this;
        }

        public final void setConnectionDraining(ConnectionDraining connectionDraining) {
            this.connectionDraining = connectionDraining;
        }

        public final ConnectionSettings getConnectionSettings() {
            return this.connectionSettings;
        }

        @Override
        public final Builder connectionSettings(ConnectionSettings connectionSettings) {
            this.connectionSettings = connectionSettings;
            return this;
        }

        public final void setConnectionSettings(ConnectionSettings connectionSettings) {
            this.connectionSettings = connectionSettings;
        }

        public final Collection<AdditionalAttribute> getAdditionalAttributes() {
            return this.additionalAttributes;
        }

        @Override
        public final Builder additionalAttributes(Collection<AdditionalAttribute> additionalAttributes) {
            this.additionalAttributes = AdditionalAttributesCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(AdditionalAttribute ... additionalAttributes) {
            if (this.additionalAttributes == null) {
                this.additionalAttributes = new SdkInternalList(additionalAttributes.length);
            }
            for (AdditionalAttribute e : additionalAttributes) {
                this.additionalAttributes.add(e);
            }
            return this;
        }

        public final void setAdditionalAttributes(Collection<AdditionalAttribute> additionalAttributes) {
            this.additionalAttributes = AdditionalAttributesCopier.copy(additionalAttributes);
        }

        @SafeVarargs
        public final void setAdditionalAttributes(AdditionalAttribute ... additionalAttributes) {
            if (this.additionalAttributes == null) {
                this.additionalAttributes = new SdkInternalList(additionalAttributes.length);
            }
            for (AdditionalAttribute e : additionalAttributes) {
                this.additionalAttributes.add(e);
            }
        }

        public LoadBalancerAttributes build() {
            return new LoadBalancerAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerAttributes> {
        public Builder crossZoneLoadBalancing(CrossZoneLoadBalancing var1);

        public Builder accessLog(AccessLog var1);

        public Builder connectionDraining(ConnectionDraining var1);

        public Builder connectionSettings(ConnectionSettings var1);

        public Builder additionalAttributes(Collection<AdditionalAttribute> var1);

        public Builder additionalAttributes(AdditionalAttribute ... var1);
    }
}

