/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceState
implements ToCopyableBuilder<Builder, InstanceState> {
    private final String instanceId;
    private final String state;
    private final String reasonCode;
    private final String description;

    private InstanceState(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.state = builder.state;
        this.reasonCode = builder.reasonCode;
        this.description = builder.description;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String state() {
        return this.state;
    }

    public String reasonCode() {
        return this.reasonCode;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.reasonCode() == null ? 0 : this.reasonCode().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceState)) {
            return false;
        }
        InstanceState other = (InstanceState)obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.reasonCode() == null ^ this.reasonCode() == null) {
            return false;
        }
        if (other.reasonCode() != null && !other.reasonCode().equals(this.reasonCode())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.reasonCode() != null) {
            sb.append("ReasonCode: ").append(this.reasonCode()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String state;
        private String reasonCode;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceState model) {
            this.setInstanceId(model.instanceId);
            this.setState(model.state);
            this.setReasonCode(model.reasonCode);
            this.setDescription(model.description);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getReasonCode() {
            return this.reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public InstanceState build() {
            return new InstanceState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceState> {
        public Builder instanceId(String var1);

        public Builder state(String var1);

        public Builder reasonCode(String var1);

        public Builder description(String var1);
    }
}

