/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTagsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private final List<TagDescription> tagDescriptions;

    private DescribeTagsResponse(BuilderImpl builder) {
        this.tagDescriptions = builder.tagDescriptions;
    }

    public List<TagDescription> tagDescriptions() {
        return this.tagDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tagDescriptions() == null ? 0 : this.tagDescriptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        if (other.tagDescriptions() == null ^ this.tagDescriptions() == null) {
            return false;
        }
        return other.tagDescriptions() == null || other.tagDescriptions().equals(this.tagDescriptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tagDescriptions() != null) {
            sb.append("TagDescriptions: ").append(this.tagDescriptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TagDescription> tagDescriptions = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            this.setTagDescriptions(model.tagDescriptions);
        }

        public final Collection<TagDescription> getTagDescriptions() {
            return this.tagDescriptions;
        }

        @Override
        public final Builder tagDescriptions(Collection<TagDescription> tagDescriptions) {
            this.tagDescriptions = TagDescriptionsCopier.copy(tagDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagDescriptions(TagDescription ... tagDescriptions) {
            if (this.tagDescriptions == null) {
                this.tagDescriptions = new SdkInternalList(tagDescriptions.length);
            }
            for (TagDescription e : tagDescriptions) {
                this.tagDescriptions.add(e);
            }
            return this;
        }

        public final void setTagDescriptions(Collection<TagDescription> tagDescriptions) {
            this.tagDescriptions = TagDescriptionsCopier.copy(tagDescriptions);
        }

        @SafeVarargs
        public final void setTagDescriptions(TagDescription ... tagDescriptions) {
            if (this.tagDescriptions == null) {
                this.tagDescriptions = new SdkInternalList(tagDescriptions.length);
            }
            for (TagDescription e : tagDescriptions) {
                this.tagDescriptions.add(e);
            }
        }

        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder tagDescriptions(Collection<TagDescription> var1);

        public Builder tagDescriptions(TagDescription ... var1);
    }
}

