/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticinference.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticinference.model.KeyValuePair;
import software.amazon.awssdk.services.elasticinference.model.MemoryInfo;
import software.amazon.awssdk.services.elasticinference.model.ThroughputInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceleratorType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AcceleratorType> {
    private static final SdkField<String> ACCELERATOR_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("acceleratorTypeName").getter(AcceleratorType.getter(AcceleratorType::acceleratorTypeName)).setter(AcceleratorType.setter(Builder::acceleratorTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTypeName").build()}).build();
    private static final SdkField<MemoryInfo> MEMORY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("memoryInfo").getter(AcceleratorType.getter(AcceleratorType::memoryInfo)).setter(AcceleratorType.setter(Builder::memoryInfo)).constructor(MemoryInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryInfo").build()}).build();
    private static final SdkField<List<KeyValuePair>> THROUGHPUT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("throughputInfo").getter(AcceleratorType.getter(AcceleratorType::throughputInfo)).setter(AcceleratorType.setter(Builder::throughputInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughputInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_TYPE_NAME_FIELD, MEMORY_INFO_FIELD, THROUGHPUT_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AcceleratorType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String acceleratorTypeName;
    private final MemoryInfo memoryInfo;
    private final List<KeyValuePair> throughputInfo;

    private AcceleratorType(BuilderImpl builder) {
        this.acceleratorTypeName = builder.acceleratorTypeName;
        this.memoryInfo = builder.memoryInfo;
        this.throughputInfo = builder.throughputInfo;
    }

    public final String acceleratorTypeName() {
        return this.acceleratorTypeName;
    }

    public final MemoryInfo memoryInfo() {
        return this.memoryInfo;
    }

    public final boolean hasThroughputInfo() {
        return this.throughputInfo != null && !(this.throughputInfo instanceof SdkAutoConstructList);
    }

    public final List<KeyValuePair> throughputInfo() {
        return this.throughputInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThroughputInfo() ? this.throughputInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceleratorType)) {
            return false;
        }
        AcceleratorType other = (AcceleratorType)obj;
        return Objects.equals(this.acceleratorTypeName(), other.acceleratorTypeName()) && Objects.equals(this.memoryInfo(), other.memoryInfo()) && this.hasThroughputInfo() == other.hasThroughputInfo() && Objects.equals(this.throughputInfo(), other.throughputInfo());
    }

    public final String toString() {
        return ToString.builder((String)"AcceleratorType").add("AcceleratorTypeName", (Object)this.acceleratorTypeName()).add("MemoryInfo", (Object)this.memoryInfo()).add("ThroughputInfo", this.hasThroughputInfo() ? this.throughputInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceleratorTypeName": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypeName()));
            }
            case "memoryInfo": {
                return Optional.ofNullable(clazz.cast(this.memoryInfo()));
            }
            case "throughputInfo": {
                return Optional.ofNullable(clazz.cast(this.throughputInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("acceleratorTypeName", ACCELERATOR_TYPE_NAME_FIELD);
        map.put("memoryInfo", MEMORY_INFO_FIELD);
        map.put("throughputInfo", THROUGHPUT_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceleratorType, T> g) {
        return obj -> g.apply((AcceleratorType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String acceleratorTypeName;
        private MemoryInfo memoryInfo;
        private List<KeyValuePair> throughputInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AcceleratorType model) {
            this.acceleratorTypeName(model.acceleratorTypeName);
            this.memoryInfo(model.memoryInfo);
            this.throughputInfo(model.throughputInfo);
        }

        public final String getAcceleratorTypeName() {
            return this.acceleratorTypeName;
        }

        public final void setAcceleratorTypeName(String acceleratorTypeName) {
            this.acceleratorTypeName = acceleratorTypeName;
        }

        @Override
        public final Builder acceleratorTypeName(String acceleratorTypeName) {
            this.acceleratorTypeName = acceleratorTypeName;
            return this;
        }

        public final MemoryInfo.Builder getMemoryInfo() {
            return this.memoryInfo != null ? this.memoryInfo.toBuilder() : null;
        }

        public final void setMemoryInfo(MemoryInfo.BuilderImpl memoryInfo) {
            this.memoryInfo = memoryInfo != null ? memoryInfo.build() : null;
        }

        @Override
        public final Builder memoryInfo(MemoryInfo memoryInfo) {
            this.memoryInfo = memoryInfo;
            return this;
        }

        public final List<KeyValuePair.Builder> getThroughputInfo() {
            List<KeyValuePair.Builder> result = ThroughputInfoListCopier.copyToBuilder(this.throughputInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThroughputInfo(Collection<KeyValuePair.BuilderImpl> throughputInfo) {
            this.throughputInfo = ThroughputInfoListCopier.copyFromBuilder(throughputInfo);
        }

        @Override
        public final Builder throughputInfo(Collection<KeyValuePair> throughputInfo) {
            this.throughputInfo = ThroughputInfoListCopier.copy(throughputInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throughputInfo(KeyValuePair ... throughputInfo) {
            this.throughputInfo(Arrays.asList(throughputInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throughputInfo(Consumer<KeyValuePair.Builder> ... throughputInfo) {
            this.throughputInfo(Stream.of(throughputInfo).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AcceleratorType build() {
            return new AcceleratorType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AcceleratorType> {
        public Builder acceleratorTypeName(String var1);

        public Builder memoryInfo(MemoryInfo var1);

        default public Builder memoryInfo(Consumer<MemoryInfo.Builder> memoryInfo) {
            return this.memoryInfo((MemoryInfo)((MemoryInfo.Builder)MemoryInfo.builder().applyMutation(memoryInfo)).build());
        }

        public Builder throughputInfo(Collection<KeyValuePair> var1);

        public Builder throughputInfo(KeyValuePair ... var1);

        public Builder throughputInfo(Consumer<KeyValuePair.Builder> ... var1);
    }
}

