/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticinference.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAcceleratorsRequest extends ElasticInferenceRequest implements
        ToCopyableBuilder<DescribeAcceleratorsRequest.Builder, DescribeAcceleratorsRequest> {
    private static final SdkField<List<String>> ACCELERATOR_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAcceleratorsRequest::acceleratorIds))
            .setter(setter(Builder::acceleratorIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAcceleratorsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeAcceleratorsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAcceleratorsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_IDS_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> acceleratorIds;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeAcceleratorsRequest(BuilderImpl builder) {
        super(builder);
        this.acceleratorIds = builder.acceleratorIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AcceleratorIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAcceleratorIds() {
        return acceleratorIds != null && !(acceleratorIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the accelerators to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAcceleratorIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the accelerators to describe.
     */
    public List<String> acceleratorIds() {
        return acceleratorIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters. Filter names and values are case-sensitive. Valid filter names are: accelerator-types: can
     * provide a list of accelerator type names to filter for. instance-id: can provide a list of EC2 instance ids to
     * filter for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters. Filter names and values are case-sensitive. Valid filter names are:
     *         accelerator-types: can provide a list of accelerator type names to filter for. instance-id: can provide a
     *         list of EC2 instance ids to filter for.
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The total number of items to return in the command's output. If the total number of items available is more than
     * the value specified, a NextToken is provided in the command's output. To resume pagination, provide the NextToken
     * value in the starting-token argument of a subsequent command. Do not use the NextToken response element directly
     * outside of the AWS CLI.
     * </p>
     * 
     * @return The total number of items to return in the command's output. If the total number of items available is
     *         more than the value specified, a NextToken is provided in the command's output. To resume pagination,
     *         provide the NextToken value in the starting-token argument of a subsequent command. Do not use the
     *         NextToken response element directly outside of the AWS CLI.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to specify where to start paginating. This is the NextToken from a previously truncated response.
     * </p>
     * 
     * @return A token to specify where to start paginating. This is the NextToken from a previously truncated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorIds());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcceleratorsRequest)) {
            return false;
        }
        DescribeAcceleratorsRequest other = (DescribeAcceleratorsRequest) obj;
        return Objects.equals(acceleratorIds(), other.acceleratorIds()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAcceleratorsRequest").add("AcceleratorIds", acceleratorIds()).add("Filters", filters())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceleratorIds":
            return Optional.ofNullable(clazz.cast(acceleratorIds()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcceleratorsRequest, T> g) {
        return obj -> g.apply((DescribeAcceleratorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticInferenceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAcceleratorsRequest> {
        /**
         * <p>
         * The IDs of the accelerators to describe.
         * </p>
         * 
         * @param acceleratorIds
         *        The IDs of the accelerators to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorIds(Collection<String> acceleratorIds);

        /**
         * <p>
         * The IDs of the accelerators to describe.
         * </p>
         * 
         * @param acceleratorIds
         *        The IDs of the accelerators to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorIds(String... acceleratorIds);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive. Valid filter names are: accelerator-types:
         * can provide a list of accelerator type names to filter for. instance-id: can provide a list of EC2 instance
         * ids to filter for.
         * </p>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive. Valid filter names are:
         *        accelerator-types: can provide a list of accelerator type names to filter for. instance-id: can
         *        provide a list of EC2 instance ids to filter for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive. Valid filter names are: accelerator-types:
         * can provide a list of accelerator type names to filter for. instance-id: can provide a list of EC2 instance
         * ids to filter for.
         * </p>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive. Valid filter names are:
         *        accelerator-types: can provide a list of accelerator type names to filter for. instance-id: can
         *        provide a list of EC2 instance ids to filter for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive. Valid filter names are: accelerator-types:
         * can provide a list of accelerator type names to filter for. instance-id: can provide a list of EC2 instance
         * ids to filter for.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The total number of items to return in the command's output. If the total number of items available is more
         * than the value specified, a NextToken is provided in the command's output. To resume pagination, provide the
         * NextToken value in the starting-token argument of a subsequent command. Do not use the NextToken response
         * element directly outside of the AWS CLI.
         * </p>
         * 
         * @param maxResults
         *        The total number of items to return in the command's output. If the total number of items available is
         *        more than the value specified, a NextToken is provided in the command's output. To resume pagination,
         *        provide the NextToken value in the starting-token argument of a subsequent command. Do not use the
         *        NextToken response element directly outside of the AWS CLI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to specify where to start paginating. This is the NextToken from a previously truncated response.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start paginating. This is the NextToken from a previously truncated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticInferenceRequest.BuilderImpl implements Builder {
        private List<String> acceleratorIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcceleratorsRequest model) {
            super(model);
            acceleratorIds(model.acceleratorIds);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAcceleratorIds() {
            return acceleratorIds;
        }

        @Override
        public final Builder acceleratorIds(Collection<String> acceleratorIds) {
            this.acceleratorIds = AcceleratorIdListCopier.copy(acceleratorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorIds(String... acceleratorIds) {
            acceleratorIds(Arrays.asList(acceleratorIds));
            return this;
        }

        public final void setAcceleratorIds(Collection<String> acceleratorIds) {
            this.acceleratorIds = AcceleratorIdListCopier.copy(acceleratorIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAcceleratorsRequest build() {
            return new DescribeAcceleratorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
