/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkAsyncClient;
import software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CodeBuildNotInServiceRegionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkServiceException;
import software.amazon.awssdk.services.elasticbeanstalk.model.InsufficientPrivilegesException;
import software.amazon.awssdk.services.elasticbeanstalk.model.InvalidRequestException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionInvalidStateException;
import software.amazon.awssdk.services.elasticbeanstalk.model.OperationInProgressException;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformVersionStillReferencedException;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ResourceTypeNotSupportedException;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3LocationNotInServiceRegionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3SubscriptionRequiredException;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBundleDeletionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyApplicationVersionsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyApplicationsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyBucketsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyConfigurationTemplatesException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyEnvironmentsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyPlatformsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.elasticbeanstalk.transform.AbortEnvironmentUpdateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ApplyEnvironmentManagedActionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CheckDnsAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ComposeEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreatePlatformVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateStorageLocationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteEnvironmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeletePlatformVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeApplicationVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeApplicationsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeConfigurationOptionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeConfigurationSettingsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentManagedActionHistoryRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentManagedActionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentResourcesRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeInstancesHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribePlatformVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ListAvailableSolutionStacksRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ListPlatformVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RebuildEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RequestEnvironmentInfoRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RestartAppServerRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RetrieveEnvironmentInfoRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.SwapEnvironmentCnamEsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.TerminateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateApplicationResourceLifecycleRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ValidateConfigurationSettingsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultElasticBeanstalkAsyncClient
implements ElasticBeanstalkAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultElasticBeanstalkAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticBeanstalkAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "elasticbeanstalk";
    }

    @Override
    public CompletableFuture<AbortEnvironmentUpdateResponse> abortEnvironmentUpdate(AbortEnvironmentUpdateRequest abortEnvironmentUpdateRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AbortEnvironmentUpdateResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("AbortEnvironmentUpdate").withMarshaller((Marshaller)new AbortEnvironmentUpdateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)abortEnvironmentUpdateRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ApplyEnvironmentManagedActionResponse> applyEnvironmentManagedAction(ApplyEnvironmentManagedActionRequest applyEnvironmentManagedActionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplyEnvironmentManagedActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplyEnvironmentManagedAction").withMarshaller((Marshaller)new ApplyEnvironmentManagedActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)applyEnvironmentManagedActionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CheckDnsAvailabilityResponse> checkDNSAvailability(CheckDnsAvailabilityRequest checkDnsAvailabilityRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CheckDnsAvailabilityResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckDNSAvailability").withMarshaller((Marshaller)new CheckDnsAvailabilityRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)checkDnsAvailabilityRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ComposeEnvironmentsResponse> composeEnvironments(ComposeEnvironmentsRequest composeEnvironmentsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ComposeEnvironmentsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ComposeEnvironments").withMarshaller((Marshaller)new ComposeEnvironmentsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)composeEnvironmentsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateApplicationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplication").withMarshaller((Marshaller)new CreateApplicationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateApplicationVersionResponse> createApplicationVersion(CreateApplicationVersionRequest createApplicationVersionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateApplicationVersionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplicationVersion").withMarshaller((Marshaller)new CreateApplicationVersionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationVersionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateConfigurationTemplateResponse> createConfigurationTemplate(CreateConfigurationTemplateRequest createConfigurationTemplateRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateConfigurationTemplateResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationTemplate").withMarshaller((Marshaller)new CreateConfigurationTemplateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationTemplateRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEnvironmentResponse> createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateEnvironmentResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEnvironment").withMarshaller((Marshaller)new CreateEnvironmentRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEnvironmentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePlatformVersionResponse> createPlatformVersion(CreatePlatformVersionRequest createPlatformVersionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreatePlatformVersionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePlatformVersion").withMarshaller((Marshaller)new CreatePlatformVersionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPlatformVersionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStorageLocationResponse> createStorageLocation(CreateStorageLocationRequest createStorageLocationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateStorageLocationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStorageLocation").withMarshaller((Marshaller)new CreateStorageLocationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStorageLocationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteApplicationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplication").withMarshaller((Marshaller)new DeleteApplicationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationVersionResponse> deleteApplicationVersion(DeleteApplicationVersionRequest deleteApplicationVersionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteApplicationVersionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationVersion").withMarshaller((Marshaller)new DeleteApplicationVersionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationVersionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConfigurationTemplateResponse> deleteConfigurationTemplate(DeleteConfigurationTemplateRequest deleteConfigurationTemplateRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteConfigurationTemplateResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationTemplate").withMarshaller((Marshaller)new DeleteConfigurationTemplateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationTemplateRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEnvironmentConfigurationResponse> deleteEnvironmentConfiguration(DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteEnvironmentConfigurationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEnvironmentConfiguration").withMarshaller((Marshaller)new DeleteEnvironmentConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEnvironmentConfigurationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePlatformVersionResponse> deletePlatformVersion(DeletePlatformVersionRequest deletePlatformVersionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeletePlatformVersionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePlatformVersion").withMarshaller((Marshaller)new DeletePlatformVersionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePlatformVersionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountAttributesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountAttributes").withMarshaller((Marshaller)new DescribeAccountAttributesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountAttributesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeApplicationVersionsResponse> describeApplicationVersions(DescribeApplicationVersionsRequest describeApplicationVersionsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeApplicationVersionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationVersions").withMarshaller((Marshaller)new DescribeApplicationVersionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationVersionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeApplicationsResponse> describeApplications(DescribeApplicationsRequest describeApplicationsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeApplicationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplications").withMarshaller((Marshaller)new DescribeApplicationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigurationOptionsResponse> describeConfigurationOptions(DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeConfigurationOptionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationOptions").withMarshaller((Marshaller)new DescribeConfigurationOptionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationOptionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigurationSettingsResponse> describeConfigurationSettings(DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeConfigurationSettingsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationSettings").withMarshaller((Marshaller)new DescribeConfigurationSettingsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationSettingsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEnvironmentHealthResponse> describeEnvironmentHealth(DescribeEnvironmentHealthRequest describeEnvironmentHealthRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEnvironmentHealthResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEnvironmentHealth").withMarshaller((Marshaller)new DescribeEnvironmentHealthRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentHealthRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEnvironmentManagedActionHistoryResponse> describeEnvironmentManagedActionHistory(DescribeEnvironmentManagedActionHistoryRequest describeEnvironmentManagedActionHistoryRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEnvironmentManagedActionHistoryResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEnvironmentManagedActionHistory").withMarshaller((Marshaller)new DescribeEnvironmentManagedActionHistoryRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentManagedActionHistoryRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEnvironmentManagedActionsResponse> describeEnvironmentManagedActions(DescribeEnvironmentManagedActionsRequest describeEnvironmentManagedActionsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEnvironmentManagedActionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEnvironmentManagedActions").withMarshaller((Marshaller)new DescribeEnvironmentManagedActionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentManagedActionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEnvironmentResourcesResponse> describeEnvironmentResources(DescribeEnvironmentResourcesRequest describeEnvironmentResourcesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEnvironmentResourcesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEnvironmentResources").withMarshaller((Marshaller)new DescribeEnvironmentResourcesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentResourcesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEnvironmentsResponse> describeEnvironments(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEnvironmentsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEnvironments").withMarshaller((Marshaller)new DescribeEnvironmentsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public CompletableFuture<DescribeInstancesHealthResponse> describeInstancesHealth(DescribeInstancesHealthRequest describeInstancesHealthRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeInstancesHealthResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstancesHealth").withMarshaller((Marshaller)new DescribeInstancesHealthRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInstancesHealthRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribePlatformVersionResponse> describePlatformVersion(DescribePlatformVersionRequest describePlatformVersionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePlatformVersionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePlatformVersion").withMarshaller((Marshaller)new DescribePlatformVersionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePlatformVersionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAvailableSolutionStacksResponse> listAvailableSolutionStacks(ListAvailableSolutionStacksRequest listAvailableSolutionStacksRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListAvailableSolutionStacksResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAvailableSolutionStacks").withMarshaller((Marshaller)new ListAvailableSolutionStacksRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAvailableSolutionStacksRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPlatformVersionsResponse> listPlatformVersions(ListPlatformVersionsRequest listPlatformVersionsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListPlatformVersionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPlatformVersions").withMarshaller((Marshaller)new ListPlatformVersionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPlatformVersionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebuildEnvironmentResponse> rebuildEnvironment(RebuildEnvironmentRequest rebuildEnvironmentRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebuildEnvironmentResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebuildEnvironment").withMarshaller((Marshaller)new RebuildEnvironmentRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebuildEnvironmentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RequestEnvironmentInfoResponse> requestEnvironmentInfo(RequestEnvironmentInfoRequest requestEnvironmentInfoRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RequestEnvironmentInfoResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("RequestEnvironmentInfo").withMarshaller((Marshaller)new RequestEnvironmentInfoRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)requestEnvironmentInfoRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestartAppServerResponse> restartAppServer(RestartAppServerRequest restartAppServerRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestartAppServerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestartAppServer").withMarshaller((Marshaller)new RestartAppServerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restartAppServerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RetrieveEnvironmentInfoResponse> retrieveEnvironmentInfo(RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RetrieveEnvironmentInfoResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetrieveEnvironmentInfo").withMarshaller((Marshaller)new RetrieveEnvironmentInfoRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)retrieveEnvironmentInfoRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SwapEnvironmentCNAMEsResponse> swapEnvironmentCNAMEs(SwapEnvironmentCnamEsRequest swapEnvironmentCnamEsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SwapEnvironmentCNAMEsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("SwapEnvironmentCNAMEs").withMarshaller((Marshaller)new SwapEnvironmentCnamEsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)swapEnvironmentCnamEsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TerminateEnvironmentResponse> terminateEnvironment(TerminateEnvironmentRequest terminateEnvironmentRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TerminateEnvironmentResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateEnvironment").withMarshaller((Marshaller)new TerminateEnvironmentRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateEnvironmentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateApplicationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplication").withMarshaller((Marshaller)new UpdateApplicationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApplicationResourceLifecycleResponse> updateApplicationResourceLifecycle(UpdateApplicationResourceLifecycleRequest updateApplicationResourceLifecycleRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateApplicationResourceLifecycleResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplicationResourceLifecycle").withMarshaller((Marshaller)new UpdateApplicationResourceLifecycleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationResourceLifecycleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApplicationVersionResponse> updateApplicationVersion(UpdateApplicationVersionRequest updateApplicationVersionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateApplicationVersionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplicationVersion").withMarshaller((Marshaller)new UpdateApplicationVersionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationVersionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateConfigurationTemplateResponse> updateConfigurationTemplate(UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateConfigurationTemplateResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationTemplate").withMarshaller((Marshaller)new UpdateConfigurationTemplateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationTemplateRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateEnvironmentResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEnvironment").withMarshaller((Marshaller)new UpdateEnvironmentRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEnvironmentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTagsForResourceResponse> updateTagsForResource(UpdateTagsForResourceRequest updateTagsForResourceRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateTagsForResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTagsForResource").withMarshaller((Marshaller)new UpdateTagsForResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTagsForResourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ValidateConfigurationSettingsResponse> validateConfigurationSettings(ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ValidateConfigurationSettingsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidateConfigurationSettings").withMarshaller((Marshaller)new ValidateConfigurationSettingsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)validateConfigurationSettingsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("S3LocationNotInServiceRegionException").exceptionBuilderSupplier(S3LocationNotInServiceRegionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ManagedActionInvalidStateException").exceptionBuilderSupplier(ManagedActionInvalidStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientPrivilegesException").exceptionBuilderSupplier(InsufficientPrivilegesException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPlatformsException").exceptionBuilderSupplier(TooManyPlatformsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyApplicationVersionsException").exceptionBuilderSupplier(TooManyApplicationVersionsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CodeBuildNotInServiceRegionException").exceptionBuilderSupplier(CodeBuildNotInServiceRegionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("S3SubscriptionRequiredException").exceptionBuilderSupplier(S3SubscriptionRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceBundleDeletionFailure").exceptionBuilderSupplier(SourceBundleDeletionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyConfigurationTemplatesException").exceptionBuilderSupplier(TooManyConfigurationTemplatesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyApplicationsException").exceptionBuilderSupplier(TooManyApplicationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationInProgressFailure").exceptionBuilderSupplier(OperationInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyEnvironmentsException").exceptionBuilderSupplier(TooManyEnvironmentsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyBucketsException").exceptionBuilderSupplier(TooManyBucketsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ElasticBeanstalkServiceException").exceptionBuilderSupplier(ElasticBeanstalkServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PlatformVersionStillReferencedException").exceptionBuilderSupplier(PlatformVersionStillReferencedException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticBeanstalkException::builder).build();
    }

    private <T extends ElasticBeanstalkRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.5.69").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticBeanstalkRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

