/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkAsyncClient;
import software.amazon.awssdk.services.elasticbeanstalk.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary;

public class ListPlatformVersionsPublisher
implements SdkPublisher<ListPlatformVersionsResponse> {
    private final ElasticBeanstalkAsyncClient client;
    private final ListPlatformVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlatformVersionsPublisher(ElasticBeanstalkAsyncClient client, ListPlatformVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlatformVersionsPublisher(ElasticBeanstalkAsyncClient client, ListPlatformVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlatformVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlatformVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PlatformSummary> platformSummaryList() {
        Function<ListPlatformVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.platformSummaryList() != null) {
                return response.platformSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPlatformVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPlatformVersionsResponseFetcher
    implements AsyncPageFetcher<ListPlatformVersionsResponse> {
        private ListPlatformVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlatformVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlatformVersionsResponse> nextPage(ListPlatformVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPlatformVersionsPublisher.this.client.listPlatformVersions(ListPlatformVersionsPublisher.this.firstRequest);
            }
            return ListPlatformVersionsPublisher.this.client.listPlatformVersions((ListPlatformVersionsRequest)((Object)ListPlatformVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

