/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckDnsAvailabilityResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, CheckDnsAvailabilityResponse> {
    private static final SdkField<Boolean> AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Available").getter(CheckDnsAvailabilityResponse.getter(CheckDnsAvailabilityResponse::available)).setter(CheckDnsAvailabilityResponse.setter(Builder::available)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Available").build()}).build();
    private static final SdkField<String> FULLY_QUALIFIED_CNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FullyQualifiedCNAME").getter(CheckDnsAvailabilityResponse.getter(CheckDnsAvailabilityResponse::fullyQualifiedCNAME)).setter(CheckDnsAvailabilityResponse.setter(Builder::fullyQualifiedCNAME)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullyQualifiedCNAME").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_FIELD, FULLY_QUALIFIED_CNAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Available", AVAILABLE_FIELD);
            this.put("FullyQualifiedCNAME", FULLY_QUALIFIED_CNAME_FIELD);
        }
    });
    private final Boolean available;
    private final String fullyQualifiedCNAME;

    private CheckDnsAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.available = builder.available;
        this.fullyQualifiedCNAME = builder.fullyQualifiedCNAME;
    }

    public final Boolean available() {
        return this.available;
    }

    public final String fullyQualifiedCNAME() {
        return this.fullyQualifiedCNAME;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.available());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullyQualifiedCNAME());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDnsAvailabilityResponse)) {
            return false;
        }
        CheckDnsAvailabilityResponse other = (CheckDnsAvailabilityResponse)((Object)obj);
        return Objects.equals(this.available(), other.available()) && Objects.equals(this.fullyQualifiedCNAME(), other.fullyQualifiedCNAME());
    }

    public final String toString() {
        return ToString.builder((String)"CheckDnsAvailabilityResponse").add("Available", (Object)this.available()).add("FullyQualifiedCNAME", (Object)this.fullyQualifiedCNAME()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Available": {
                return Optional.ofNullable(clazz.cast(this.available()));
            }
            case "FullyQualifiedCNAME": {
                return Optional.ofNullable(clazz.cast(this.fullyQualifiedCNAME()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CheckDnsAvailabilityResponse, T> g) {
        return obj -> g.apply((CheckDnsAvailabilityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private Boolean available;
        private String fullyQualifiedCNAME;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDnsAvailabilityResponse model) {
            super(model);
            this.available(model.available);
            this.fullyQualifiedCNAME(model.fullyQualifiedCNAME);
        }

        public final Boolean getAvailable() {
            return this.available;
        }

        public final void setAvailable(Boolean available) {
            this.available = available;
        }

        @Override
        public final Builder available(Boolean available) {
            this.available = available;
            return this;
        }

        public final String getFullyQualifiedCNAME() {
            return this.fullyQualifiedCNAME;
        }

        public final void setFullyQualifiedCNAME(String fullyQualifiedCNAME) {
            this.fullyQualifiedCNAME = fullyQualifiedCNAME;
        }

        @Override
        public final Builder fullyQualifiedCNAME(String fullyQualifiedCNAME) {
            this.fullyQualifiedCNAME = fullyQualifiedCNAME;
            return this;
        }

        @Override
        public CheckDnsAvailabilityResponse build() {
            return new CheckDnsAvailabilityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckDnsAvailabilityResponse> {
        public Builder available(Boolean var1);

        public Builder fullyQualifiedCNAME(String var1);
    }
}

