/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SwapEnvironmentCnamEsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, SwapEnvironmentCnamEsRequest> {
    private static final SdkField<String> SOURCE_ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEnvironmentId").getter(SwapEnvironmentCnamEsRequest.getter(SwapEnvironmentCnamEsRequest::sourceEnvironmentId)).setter(SwapEnvironmentCnamEsRequest.setter(Builder::sourceEnvironmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEnvironmentId").build()}).build();
    private static final SdkField<String> SOURCE_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEnvironmentName").getter(SwapEnvironmentCnamEsRequest.getter(SwapEnvironmentCnamEsRequest::sourceEnvironmentName)).setter(SwapEnvironmentCnamEsRequest.setter(Builder::sourceEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEnvironmentName").build()}).build();
    private static final SdkField<String> DESTINATION_ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationEnvironmentId").getter(SwapEnvironmentCnamEsRequest.getter(SwapEnvironmentCnamEsRequest::destinationEnvironmentId)).setter(SwapEnvironmentCnamEsRequest.setter(Builder::destinationEnvironmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEnvironmentId").build()}).build();
    private static final SdkField<String> DESTINATION_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationEnvironmentName").getter(SwapEnvironmentCnamEsRequest.getter(SwapEnvironmentCnamEsRequest::destinationEnvironmentName)).setter(SwapEnvironmentCnamEsRequest.setter(Builder::destinationEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEnvironmentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ENVIRONMENT_ID_FIELD, SOURCE_ENVIRONMENT_NAME_FIELD, DESTINATION_ENVIRONMENT_ID_FIELD, DESTINATION_ENVIRONMENT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SourceEnvironmentId", SOURCE_ENVIRONMENT_ID_FIELD);
            this.put("SourceEnvironmentName", SOURCE_ENVIRONMENT_NAME_FIELD);
            this.put("DestinationEnvironmentId", DESTINATION_ENVIRONMENT_ID_FIELD);
            this.put("DestinationEnvironmentName", DESTINATION_ENVIRONMENT_NAME_FIELD);
        }
    });
    private final String sourceEnvironmentId;
    private final String sourceEnvironmentName;
    private final String destinationEnvironmentId;
    private final String destinationEnvironmentName;

    private SwapEnvironmentCnamEsRequest(BuilderImpl builder) {
        super(builder);
        this.sourceEnvironmentId = builder.sourceEnvironmentId;
        this.sourceEnvironmentName = builder.sourceEnvironmentName;
        this.destinationEnvironmentId = builder.destinationEnvironmentId;
        this.destinationEnvironmentName = builder.destinationEnvironmentName;
    }

    public final String sourceEnvironmentId() {
        return this.sourceEnvironmentId;
    }

    public final String sourceEnvironmentName() {
        return this.sourceEnvironmentName;
    }

    public final String destinationEnvironmentId() {
        return this.destinationEnvironmentId;
    }

    public final String destinationEnvironmentName() {
        return this.destinationEnvironmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEnvironmentName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SwapEnvironmentCnamEsRequest)) {
            return false;
        }
        SwapEnvironmentCnamEsRequest other = (SwapEnvironmentCnamEsRequest)((Object)obj);
        return Objects.equals(this.sourceEnvironmentId(), other.sourceEnvironmentId()) && Objects.equals(this.sourceEnvironmentName(), other.sourceEnvironmentName()) && Objects.equals(this.destinationEnvironmentId(), other.destinationEnvironmentId()) && Objects.equals(this.destinationEnvironmentName(), other.destinationEnvironmentName());
    }

    public final String toString() {
        return ToString.builder((String)"SwapEnvironmentCnamEsRequest").add("SourceEnvironmentId", (Object)this.sourceEnvironmentId()).add("SourceEnvironmentName", (Object)this.sourceEnvironmentName()).add("DestinationEnvironmentId", (Object)this.destinationEnvironmentId()).add("DestinationEnvironmentName", (Object)this.destinationEnvironmentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceEnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.sourceEnvironmentId()));
            }
            case "SourceEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.sourceEnvironmentName()));
            }
            case "DestinationEnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.destinationEnvironmentId()));
            }
            case "DestinationEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.destinationEnvironmentName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SwapEnvironmentCnamEsRequest, T> g) {
        return obj -> g.apply((SwapEnvironmentCnamEsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String sourceEnvironmentId;
        private String sourceEnvironmentName;
        private String destinationEnvironmentId;
        private String destinationEnvironmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(SwapEnvironmentCnamEsRequest model) {
            super(model);
            this.sourceEnvironmentId(model.sourceEnvironmentId);
            this.sourceEnvironmentName(model.sourceEnvironmentName);
            this.destinationEnvironmentId(model.destinationEnvironmentId);
            this.destinationEnvironmentName(model.destinationEnvironmentName);
        }

        public final String getSourceEnvironmentId() {
            return this.sourceEnvironmentId;
        }

        public final void setSourceEnvironmentId(String sourceEnvironmentId) {
            this.sourceEnvironmentId = sourceEnvironmentId;
        }

        @Override
        public final Builder sourceEnvironmentId(String sourceEnvironmentId) {
            this.sourceEnvironmentId = sourceEnvironmentId;
            return this;
        }

        public final String getSourceEnvironmentName() {
            return this.sourceEnvironmentName;
        }

        public final void setSourceEnvironmentName(String sourceEnvironmentName) {
            this.sourceEnvironmentName = sourceEnvironmentName;
        }

        @Override
        public final Builder sourceEnvironmentName(String sourceEnvironmentName) {
            this.sourceEnvironmentName = sourceEnvironmentName;
            return this;
        }

        public final String getDestinationEnvironmentId() {
            return this.destinationEnvironmentId;
        }

        public final void setDestinationEnvironmentId(String destinationEnvironmentId) {
            this.destinationEnvironmentId = destinationEnvironmentId;
        }

        @Override
        public final Builder destinationEnvironmentId(String destinationEnvironmentId) {
            this.destinationEnvironmentId = destinationEnvironmentId;
            return this;
        }

        public final String getDestinationEnvironmentName() {
            return this.destinationEnvironmentName;
        }

        public final void setDestinationEnvironmentName(String destinationEnvironmentName) {
            this.destinationEnvironmentName = destinationEnvironmentName;
        }

        @Override
        public final Builder destinationEnvironmentName(String destinationEnvironmentName) {
            this.destinationEnvironmentName = destinationEnvironmentName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SwapEnvironmentCnamEsRequest build() {
            return new SwapEnvironmentCnamEsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SwapEnvironmentCnamEsRequest> {
        public Builder sourceEnvironmentId(String var1);

        public Builder sourceEnvironmentName(String var1);

        public Builder destinationEnvironmentId(String var1);

        public Builder destinationEnvironmentName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

