/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveEnvironmentInfoResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, RetrieveEnvironmentInfoResponse> {
    private static final SdkField<List<EnvironmentInfoDescription>> ENVIRONMENT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentInfo").getter(RetrieveEnvironmentInfoResponse.getter(RetrieveEnvironmentInfoResponse::environmentInfo)).setter(RetrieveEnvironmentInfoResponse.setter(Builder::environmentInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentInfoDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_INFO_FIELD));
    private final List<EnvironmentInfoDescription> environmentInfo;

    private RetrieveEnvironmentInfoResponse(BuilderImpl builder) {
        super(builder);
        this.environmentInfo = builder.environmentInfo;
    }

    public boolean hasEnvironmentInfo() {
        return this.environmentInfo != null && !(this.environmentInfo instanceof SdkAutoConstructList);
    }

    public List<EnvironmentInfoDescription> environmentInfo() {
        return this.environmentInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentInfo() ? this.environmentInfo() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveEnvironmentInfoResponse)) {
            return false;
        }
        RetrieveEnvironmentInfoResponse other = (RetrieveEnvironmentInfoResponse)((Object)obj);
        return this.hasEnvironmentInfo() == other.hasEnvironmentInfo() && Objects.equals(this.environmentInfo(), other.environmentInfo());
    }

    public String toString() {
        return ToString.builder((String)"RetrieveEnvironmentInfoResponse").add("EnvironmentInfo", this.hasEnvironmentInfo() ? this.environmentInfo() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentInfo": {
                return Optional.ofNullable(clazz.cast(this.environmentInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveEnvironmentInfoResponse, T> g) {
        return obj -> g.apply((RetrieveEnvironmentInfoResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<EnvironmentInfoDescription> environmentInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveEnvironmentInfoResponse model) {
            super(model);
            this.environmentInfo(model.environmentInfo);
        }

        public final Collection<EnvironmentInfoDescription.Builder> getEnvironmentInfo() {
            if (this.environmentInfo instanceof SdkAutoConstructList) {
                return null;
            }
            return this.environmentInfo != null ? (Collection)this.environmentInfo.stream().map(EnvironmentInfoDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environmentInfo(Collection<EnvironmentInfoDescription> environmentInfo) {
            this.environmentInfo = EnvironmentInfoDescriptionListCopier.copy(environmentInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInfo(EnvironmentInfoDescription ... environmentInfo) {
            this.environmentInfo(Arrays.asList(environmentInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInfo(Consumer<EnvironmentInfoDescription.Builder> ... environmentInfo) {
            this.environmentInfo(Stream.of(environmentInfo).map(c -> (EnvironmentInfoDescription)((EnvironmentInfoDescription.Builder)EnvironmentInfoDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironmentInfo(Collection<EnvironmentInfoDescription.BuilderImpl> environmentInfo) {
            this.environmentInfo = EnvironmentInfoDescriptionListCopier.copyFromBuilder(environmentInfo);
        }

        @Override
        public RetrieveEnvironmentInfoResponse build() {
            return new RetrieveEnvironmentInfoResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetrieveEnvironmentInfoResponse> {
        public Builder environmentInfo(Collection<EnvironmentInfoDescription> var1);

        public Builder environmentInfo(EnvironmentInfoDescription ... var1);

        public Builder environmentInfo(Consumer<EnvironmentInfoDescription.Builder> ... var1);
    }
}

