/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescriptionListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationVersionsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeApplicationVersionsResponse> {
    private static final SdkField<List<ApplicationVersionDescription>> APPLICATION_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationVersions").getter(DescribeApplicationVersionsResponse.getter(DescribeApplicationVersionsResponse::applicationVersions)).setter(DescribeApplicationVersionsResponse.setter(Builder::applicationVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationVersionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeApplicationVersionsResponse.getter(DescribeApplicationVersionsResponse::nextToken)).setter(DescribeApplicationVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ApplicationVersionDescription> applicationVersions;
    private final String nextToken;

    private DescribeApplicationVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationVersions = builder.applicationVersions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasApplicationVersions() {
        return this.applicationVersions != null && !(this.applicationVersions instanceof SdkAutoConstructList);
    }

    public List<ApplicationVersionDescription> applicationVersions() {
        return this.applicationVersions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationVersions() ? this.applicationVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationVersionsResponse)) {
            return false;
        }
        DescribeApplicationVersionsResponse other = (DescribeApplicationVersionsResponse)((Object)obj);
        return this.hasApplicationVersions() == other.hasApplicationVersions() && Objects.equals(this.applicationVersions(), other.applicationVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeApplicationVersionsResponse").add("ApplicationVersions", this.hasApplicationVersions() ? this.applicationVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationVersions": {
                return Optional.ofNullable(clazz.cast(this.applicationVersions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationVersionsResponse, T> g) {
        return obj -> g.apply((DescribeApplicationVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<ApplicationVersionDescription> applicationVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationVersionsResponse model) {
            super(model);
            this.applicationVersions(model.applicationVersions);
            this.nextToken(model.nextToken);
        }

        public final Collection<ApplicationVersionDescription.Builder> getApplicationVersions() {
            if (this.applicationVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationVersions != null ? (Collection)this.applicationVersions.stream().map(ApplicationVersionDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applicationVersions(Collection<ApplicationVersionDescription> applicationVersions) {
            this.applicationVersions = ApplicationVersionDescriptionListCopier.copy(applicationVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationVersions(ApplicationVersionDescription ... applicationVersions) {
            this.applicationVersions(Arrays.asList(applicationVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationVersions(Consumer<ApplicationVersionDescription.Builder> ... applicationVersions) {
            this.applicationVersions(Stream.of(applicationVersions).map(c -> (ApplicationVersionDescription)((ApplicationVersionDescription.Builder)ApplicationVersionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApplicationVersions(Collection<ApplicationVersionDescription.BuilderImpl> applicationVersions) {
            this.applicationVersions = ApplicationVersionDescriptionListCopier.copyFromBuilder(applicationVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeApplicationVersionsResponse build() {
            return new DescribeApplicationVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationVersionsResponse> {
        public Builder applicationVersions(Collection<ApplicationVersionDescription> var1);

        public Builder applicationVersions(ApplicationVersionDescription ... var1);

        public Builder applicationVersions(Consumer<ApplicationVersionDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

