/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest;

public class RebuildEnvironmentRequestMarshaller
implements Marshaller<Request<RebuildEnvironmentRequest>, RebuildEnvironmentRequest> {
    public Request<RebuildEnvironmentRequest> marshall(RebuildEnvironmentRequest rebuildEnvironmentRequest) {
        if (rebuildEnvironmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)rebuildEnvironmentRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "RebuildEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (rebuildEnvironmentRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)rebuildEnvironmentRequest.environmentId()));
        }
        if (rebuildEnvironmentRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)rebuildEnvironmentRequest.environmentName()));
        }
        return request;
    }
}

