/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;

public class OptionSpecificationUnmarshaller
implements Unmarshaller<OptionSpecification, StaxUnmarshallerContext> {
    private static final OptionSpecificationUnmarshaller INSTANCE = new OptionSpecificationUnmarshaller();

    public OptionSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        OptionSpecification.Builder optionSpecification = OptionSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ResourceName", targetDepth)) {
                    optionSpecification.resourceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Namespace", targetDepth)) {
                    optionSpecification.namespace(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OptionName", targetDepth)) continue;
                optionSpecification.optionName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (OptionSpecification)optionSpecification.build();
    }

    public static OptionSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

